/*
 * This file is part of the OLH system.
 * It is used to show the information on a node
 *
 *      Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/info.c,v $
 *      $Id: info.c,v 1.2 91/04/29 00:23:13 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include <olh.h>
#include <sys/types.h>
#include <sys/stat.h>

void
show_info()
{
  MenuEntry *e,*e2;
  EntryField *f, *fstop;
  EntryField *f2, *f2stop;
  int i;
  long code;
  struct stat statb;

  if (current[current_menu] == 0) {
    OLH_ui_message("Please select an item first.");
    return;
  }

  e = nth_entry(menu[current_menu],current[current_menu]);

  /* Print heading */
  wclear(scr_view);
  wmove(scr_view,2,2);
  wprintw(scr_view,"Information on module \"%s\"",
	  field_value(e,NODE_LABEL));

  fstop = e->field + e->size;
  i = 4;
  for (f=e->field;f<fstop;f++) {
    wmove(scr_view,i++,4);
    wprintw(scr_view,"%-15s %s\n",f->name,f->value);

    if (f->name == POINTER) {
      /* Retrieve information from pointer */

      code = pointerEntry(f->value,&e2);
      if (!code && e2) {
	wmove(scr_view,i++,2);
	waddstr(scr_view,"--- pointer information ---");
	f2stop = e2->field + e2->size;
	for (f2 = e2->field; f2<f2stop; f2++) {
	  wmove(scr_view,i++,4);
	  wprintw(scr_view,"%-15s %s\n",f2->name,f2->value);
	  if (f2->name == FILE_LOCATION) {
	    if (stat(f2->value,&statb) == 0) {
	      wmove(scr_view,i++,4);
	      wprintw(scr_view, "%-15s %s", "modify-date",
		      ctime(&statb.st_mtime));
	    }
	  }			    
	}
      }
    }
  }
  set_current_screen(SCR_VIEW);
  wait_for_key(win_view_wait);
  set_current_screen(SCR_PRIM);
}
