/*
 * This file is part of the OLH system.
 *
 *      Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/keyword.c,v $
 *      $Id: keyword.c,v 1.1 91/03/14 16:06:24 lwvanels Exp $
 *      $Author: lwvanels $
 */

#ifndef lint
#ifndef SABER
static char *RCSid = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/ascii/RCS/keyword.c,v 1.1 91/03/14 16:06:24 lwvanels Exp $";
#endif
#endif

#include "olh.h"

void
do_keyword_startup(kw)
     char *kw;
{
  char old_mp[1024];
  int number;

  if (kw[0] == PATH_SEP_CHAR) {
    /* build menupath from argument */
    strcpy(old_mp,menupath);
    resize_menupath(strlen(kw));
    strcpy(menupath,kw);
    doing_keywords = 0;
    keyword_level = 0;
    construct_context(menupath);
    OLH_ui_update_menus();
    return;
  }
  else {
    doing_keywords = 1;
    display_keyword_menu();
    number = find_keyword_index(kw,1);
    if (number == -1) {
      sprintf(old_mp,"\"%s\" is an invalid keyword",kw);
      OLH_ui_message(old_mp);
    }
    else
      invoke_k_item(number);
  }
}
