/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /source/athena/athena.bin/olh/motif/RCS/test.c,v $
 *      $Id: test.c,v 1.1 1992/05/01 17:09:43 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include <stdio.h>
#include <Xm/Xm.h>

#define MOTIF_STRING(s)	\
  (fprintf(stderr, "DEBUG (motif_string: %d): %s\n", strlen((s)), (s)), \
  XmStringLtoRCreate((s), XmSTRING_DEFAULT_CHARSET))


char *testing[]= {
"ajax",
"bias",
"ceres",
"electra",
"europa",
"hayden",
"helios",
"homer",
"linus",
"medea",
"pandora",
"picus",
"plato",
"python",
"thesis",
"w20-east-1",
"w20-east-2",
"w20-east-3",
"w20-east-4",
" ",
"   1*  Athena Rules, Policies, and Announcements",
"   2*  System News and Release Notes",
"   3*  Getting Started on Athena",
"   4*  Understanding the Athena System",
"   5*  Managing Your Athena Account",
"   6*  Working with Files and Directories",
"   7*  Using X Windows",
"   8*  Printing",
"   9*  Communicating with Other Users",
"  10*  Text Processing (editing and formatting)",
"  11*  Data Analysis and Plotting",
"  12    Graphics",
"  13    Other Available Applications Software",
"  14*  Programming on Athena",
"  15    MIT Courses on Athena",
"  16*  Documentation Library and Archives",
"Documentation Browser Main Menu",
"Copyright (c) 1990 Massachusetts Institute of Technology     XOLH v0.7",
"Documentation Browser Main Menu",
"Keyword list",
"    account",
"    accounts",
"    Andrew",
"    answers",
"    Athena, introduction",
"    c",
"    cc",
"    color workstations",
"    common questions",
"*  configuration files",
"    console window",
"    data analysis",
"*  dialup",
"    discuss",
"    documentation",
"*  dotfiles",
"*  editing",
"*  emacs",
"*  email",
"*  ez",
"*  f77",
"    formatting",
"*  fortran",
"    getting started on Athena",
"    gnus",
"    languages, programming",
"*  latex",
"*  lisp",
"    login configuration files",
"    login sequence, remote devices",
"    login sequence, workstations",
"*  lpq",
"*  lpr",
"*  mail",
"*  matlab",
"*  mh",
"    netnews",
"    networks",
"    olc_answers",
"    operations",
"*  output",
"    policies",
"    previewers",
"*  printing",
"    programming, fortran",
"    programming",
"    psrev",
"    quota",
"    release 6.3",
"*  release 7.0",
"    release 7.1",
"    release notes",
"    rrn",
"*  rs1",
"    rules",
"    schedules",
"    scheme",
"*  scribe",
"    services",
"    statistics, rs1",
"    stock answers",
"    text editor",
"    text formatter",
"    thesis, scribe",
"*  tv, watching",
"    unix",
"    video control program (gctl)",
"    video workstations",
"    viewscribe",
"*  windowgrams",
"    windows",
"*  word processing",
"    workstations, color",
"    workstations, video",
"    workstations",
"    x11r4",
"    x",
"    xdm",
"    xlogin",
"    xmh",
"    xrn",
"*  zephyr",
"    zwrite",
" ",
"Topics matching keyword \"zephyr\"",
"    Zephyr",
"    Common questions about Zephyr",
"Documentation Browser Main Menu",
};

#define NUMWORDS (sizeof(testing)/sizeof(char *))

main(argc, argv)
     int argc;
     char **argv;
{
  int n, m;

  printf ("There are %d words.\n", NUMWORDS);
  for (m=0; m < 4; m++)
  for (n=0; n < NUMWORDS; n++)
    MOTIF_STRING(testing[n]);
}
