#!/bin/sh

if [ ! -x /mit/techinfo/ ]; then
	/bin/athena/attach -h -n -q -a -r techinfo
fi

MACH=`machtype`
case "$MACH" in

inbsd|linux)
	ti_prog=/mit/techinfo/arch/@sys/bin/techinfo
	;;
*)
	ti_prog=/mit/techinfo/techinfo
	;;
esac

if [ ! -x ${ti_prog} ]; then
	echo "Sorry, can't find techinfo program. Unavailable at the moment."
	exit
else
	exec ${ti_prog} "$@"
fi
