/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sat Oct  3 21:59:20 MET 1992 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef XC
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xc/Xc.h>
#include "wafe.h"

#define lcdUpdateValue(widget, val) XcLcdUpdateValue(widget, &val)

/* 
 * void
 * lcdUpdateValue  vulgo xcLcdUpdateValue
 * in:	Widget
 * in:	float
 */

int 
com_xcLcdUpdateValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;

     DBUG_ENTER("xcLcdUpdateValue");  

     if (argc != 3) 
	 {
	 argcError("xcLcdUpdateValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("xcLcdUpdateValue","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%f", &localVar2)))
          {
          convError("xcLcdUpdateValue","2",argv[2],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     lcdUpdateValue(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XcLedSetState vulgo xcLedSetState
 * in:	Widget
 * in:	char *
 * in:	char *
 */

int 
com_xcLedSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;
     char * localVar3;

     DBUG_ENTER("xcLedSetState");  

     if (argc != 4) 
	 {
	 argcError("xcLedSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("xcLedSetState","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign to localVar2 = argv[2]  */ 

    /* no need to assign to localVar3 = argv[3]  */ 

     XcLedSetState(localVar1,argv[2],argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xc/ToggleB.h>

/* 
 * void
 * XcToggleSet vulgo xcToggleSet
 * in:	Widget
 * in: 	XcToggleState
 */

int 
com_xcToggleSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XcToggleState localVar2;

     DBUG_ENTER("xcToggleSet");  

     if (argc != 3) 
	 {
	 argcError("xcToggleSet","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("xcToggleSet","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "on")) 
         localVar2 = XcOn;
     else
     if (!strcmp(argv[2], "off")) 
         localVar2 = XcOff;
     else
         {
         convError("xcToggleSet","2",argv[2],"XcToggleState");
         DBUG_RETURN (TCL_ERROR);
        }


     XcToggleSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XcToggleGet vulgo xcToggleGet
 * in:	Widget
 * out:	XcToggleState

 */

int 
com_xcToggleGet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XcToggleState localVar2;
     char conversionBuffer[100];

     DBUG_ENTER("xcToggleGet");  

     if (argc != 3) 
	 {
	 argcError("xcToggleGet","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("xcToggleGet","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XcToggleGet(localVar1,&localVar2);

          if (localVar2 == XcOn) 
          strcpy(conversionBuffer, "on");
     else
     if (localVar2 == XcOff) 
          strcpy(conversionBuffer, "off");


     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_XcGen()
{
#ifdef XC
 createWidgetCommand("xcBarGraph",barGraphWidgetClass,NULL);
 createWidgetCommand("xcControl",controlWidgetClass,NULL);
 createWidgetCommand("xcLcd",lcdWidgetClass,NULL);
 createWidgetCommand("xcLedButton",ledButtonWidgetClass,NULL);
 createWidgetCommand("xcSimpleButton",simpleButtonWidgetClass,NULL);
 createWidgetCommand("xcSlider",sliderWidgetClass,NULL);
 createWidgetCommand("xcToggleButton",toggleButtonWidgetClass,NULL);
 createWidgetCommand("xcValue",valueWidgetClass,NULL);
 createWidgetCommand("xcValueButton",valueButtonWidgetClass,NULL);
 Tcl_CreateCommand(interpreter, "xcLcdUpdateValue", com_xcLcdUpdateValue, NULL, NULL);
 Tcl_CreateCommand(interpreter, "xcLedSetState", com_xcLedSetState, NULL, NULL);
 Tcl_CreateCommand(interpreter, "xcToggleSet", com_xcToggleSet, NULL, NULL);
 Tcl_CreateCommand(interpreter, "xcToggleGet", com_xcToggleGet, NULL, NULL);

#else
#endif
}
