/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Oct 12 04:33:37 MET 1993 on dec1.wu-wien.ac.at
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef MOTIF11

#define MOTIF11_C

#include "wafe.h"
#include <Xm/Xm.h>
#include <X11/Shell.h>

/* 
 * ******* begin required file <motif.inc> *******
 */
/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50



XmStringCharSet    defaultCharSet;

/*
#define defaultCharSet XmSTRING_DEFAULT_CHARSET
*/

/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmString          dummy;
    XmStringContext   strContext;
    char              *text;
    XmStringCharSet   tmpCharSet;
    XmStringDirection dummyDir;
    Boolean           dummySep;
    dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	exit(-1);
	}

    XmStringGetNextSegment(strContext, &text, &tmpCharSet, 
			   &dummyDir, &dummySep);

    defaultCharSet = XtNewString(tmpCharSet);

    XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(strContext);
    
/*
    fprintf(stderr, "Setting defaultCharSet to %s default <%s> (XmSTRING_DEFAULT_CHARSET)\n", 
	    defaultCharSet, XmSTRING_DEFAULT_CHARSET);
*/
    /* xpmRegisterTypeConverter(XmCPixmap, True);*/
    xpmRegisterTypeConverter("XmBackgroundPixmap", True);
    }



/*
 * Utility function: Creates a new compound string segment, appends it 
 * to an existing XmString. Does NOT create a segement if the string is empty!
 */

XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;
    
    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString    
stringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET; 
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;
    
/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	    
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		fprintf(stderr, 
		    "Wafe(XmString Conversion): Cannot handle trailing '^'\n");
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		    
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf, 
					      charSet, dir, False);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr) 
			    || (*ptr == '-') 
			    || (*ptr == '_')) 
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		    
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	    
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	    
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);
    return result;
    }


XmStringTable
stringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = stringToXmString(argv[i])))
	    {
	    convError("stringToXmStringTable","n",argv[i],"XmString");
	    return NULL;
	    }
    *t = NULL;

    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

char *
xmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet, 
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir, 
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    Boolean            sep;
    Boolean            fontChange;
    char               *returnString, *ptr;

    DBUG_ENTER("xmString2String");
    
    if (!XmStringInitContext(&strContext, compStr))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	return(NULL);
	}

    if (!buffer) 
	{
	ptr = returnString = XtMalloc(XmStringLength(compStr)+100); /* hack  for now */
/*	fprintf(stderr, "buffer new allocated %p, size=%d\n", 
		ptr,XmStringLength(compStr));
 */
	}
    else
	{
	fprintf(stderr, "using provided buffer %p\n", buffer);
	ptr = returnString = buffer;	
	}


    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	fontChange = strcmp(charSet, lastCharSet);

	/* This means: If there are no changes in charSet or direction, 
	 * just make a newline but don't do it, if this is the first segment 
	 */
	if (   (!fontChange)
	    && (dir == lastDir) 
	    && (returnString != ptr))
	    *ptr++ = '\n'; 

	if (fontChange 
#ifdef XmFONTLIST_DEFAULT_TAG
	    /* Motif 1.2 seems to want it that way ... */
	    && strcmp(charSet,XmFONTLIST_DEFAULT_TAG)
#endif
	    ) 
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir) 
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	    

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
/*
    fprintf(stderr,"xmString2String returns <%s> size=%d\n",
	    returnString,strlen(returnString));
*/
    DBUG_RETURN(returnString);
    }

void
exmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    char *p = xmString2String(NULL,compStr);
    estrcpy(buffer,p);
    XtFree(p);
    }


/*
char *
exmStringTable2String(buffer,count,strTable)
char          * buffer;
int           count;
XmStringTable strTable;
    {
    char *p = xmStringTable2String(count,strTable)
    estrcpy(buffer,p);
    XtFree(p);
    }
*/


char *
xmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char    **temp, **cPtr;
    XmString  *ptr = strTable;
    char      *result;
    int        i;

    DBUG_ENTER("xmStringTable2String");
    
    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--) 
	{
	*cPtr = xmString2String(NULL,*ptr);
	}

    result = Tcl_Merge(count, temp);
    
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);
  
    XtFree((char *)temp);
    DBUG_RETURN (result); 
    }

/*
 * Two converter function wrappers for the *2String functions, which are 
 * called by getValues
 */

Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringToString");
    result = xmString2String(NULL,(XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    DBUG_RETURN(True);
    }


Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = xmStringTable2String(0,(XmStringTable)(fromVal->addr));

    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


void
freeStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *) table);
    }	    
    


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv) 
	!= TCL_OK)
	{
	fprintf(stderr, "Wafe(XmStringTableConversion): %s\n", 
		wafeInterpreter->result);
	return False;
	}


    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++) 
	if ((*ptr = stringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					     "XmString");
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
    XtFree((char *)argv);

    if (toVal->addr) 
	{
	fprintf(stderr,"somebody else called CvtStringToXmStrings! size=%d\n",
		toVal->size);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

	
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
	      (char *)result, freeStringTable);

    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

/*    fprintf(stderr, "CvtStringToXmString: <%s> %p\n", 
	    fromVal->addr, toVal->addr);
 */

    if ((result = stringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	DBUG_RETURN(False);
	}
    
    if (toVal->addr) 
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}
    
    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;
    
    MMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
	      (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


/* 
 * ******* end required file <motif.inc> *******
 */
/* 
 * Boolean
 * XmProcessTraversal
 * 	in: Widget		# Widget for which to traverse hierarchie
 * 	in: (int) XmTravDir	# direction in which to traverse widget hierarchie
 */

int 
com_mProcessTraversal(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mProcessTraversal");  

     if (argc != 3) 
	 {
	 argcError("mProcessTraversal","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mProcessTraversal","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "TRAVERSE_CURRENT")) 
         localVar2 = XmTRAVERSE_CURRENT;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT")) 
         localVar2 = XmTRAVERSE_NEXT;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV")) 
         localVar2 = XmTRAVERSE_PREV;
     else
     if (!strcmp(argv[2], "TRAVERSE_HOME")) 
         localVar2 = XmTRAVERSE_HOME;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_NEXT_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_PREV_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_UP")) 
         localVar2 = XmTRAVERSE_UP;
     else
     if (!strcmp(argv[2], "TRAVERSE_DOWN")) 
         localVar2 = XmTRAVERSE_DOWN;
     else
     if (!strcmp(argv[2], "TRAVERSE_LEFT")) 
         localVar2 = XmTRAVERSE_LEFT;
     else
     if (!strcmp(argv[2], "TRAVERSE_RIGHT")) 
         localVar2 = XmTRAVERSE_RIGHT;
     else
         {
         convError("mProcessTraversal","2",argv[2],"XmTravDir");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmProcessTraversal(localVar1,localVar2);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

int 
com_mCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mCascadeButtonGadgetHighlight");  

     if (argc != 3) 
	 {
	 argcError("mCascadeButtonGadgetHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          convError("mCascadeButtonGadgetHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mCascadeButtonGadgetHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: XmCascadeButtonGadget   	# widget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

int 
com_mCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mCascadeButtonHighlight");  

     if (argc != 3) 
	 {
	 argcError("mCascadeButtonHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
          {
          convError("mCascadeButtonHighlight","1",argv[1],"XmCascadeButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mCascadeButtonHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Command.h>
/* 
 * void
 * XmCommandAppendValue
 * 	in: XmCommandWidget          	# command widget 
 * 	in: XmString         		# command string
 */

int 
com_mCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mCommandAppendValue");  

     if (argc != 3) 
	 {
	 argcError("mCommandAppendValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          convError("mCommandAppendValue","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mCommandAppendValue","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmCommandError
 * 	in: XmCommandWidget           	# command widget 
 * 	in: XmString         		# error message
 */

int 
com_mCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mCommandError");  

     if (argc != 3) 
	 {
	 argcError("mCommandError","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
          {
          convError("mCommandError","1",argv[1],"XmCommandWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mCommandError","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
/* 
 * Widget
 * XmFileSelectionBoxGetChild
 * 	in: XmFileSelectionBoxWidget		# file selection box widget
 * 	in: (unsigned char)XmChild 		# child reference
 */

int 
com_mFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mFileSelectionBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("mFileSelectionBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          convError("mFileSelectionBoxGetChild","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("mFileSelectionBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmFileSelectionBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: XmFileSelectionBoxWidget		# file selection box
 * 	in: XmString				# directory mask
 */

int 
com_mFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mFileSelectionDoSearch");  

     if (argc != 3) 
	 {
	 argcError("mFileSelectionDoSearch","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
          {
          convError("mFileSelectionDoSearch","1",argv[1],"XmFileSelectionBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mFileSelectionDoSearch","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmFileSelectionDoSearch(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
/* 
 * void
 * XmListAddItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

int 
com_mListAddItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("mListAddItem");  

     if (argc != 4) 
	 {
	 argcError("mListAddItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListAddItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListAddItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListAddItem","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 * 	in: int			# position
 */

int 
com_mListAddItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("mListAddItems");  

     if (argc != 5) 
	 {
	 argcError("mListAddItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListAddItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("mListAddItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListAddItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("mListAddItems","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItems(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItemUnselected
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

int 
com_mListAddItemUnselected(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER("mListAddItemUnselected");  

     if (argc != 4) 
	 {
	 argcError("mListAddItemUnselected","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListAddItemUnselected","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListAddItemUnselected","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListAddItemUnselected","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListAddItemUnselected(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteAllItems
 * 	in: XmListWidget	# List Widget
 */

int 
com_mListDeleteAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mListDeleteAllItems");  

     if (argc != 2) 
	 {
	 argcError("mListDeleteAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeleteAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to delete
 */

int 
com_mListDeleteItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mListDeleteItem");  

     if (argc != 3) 
	 {
	 argcError("mListDeleteItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeleteItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListDeleteItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 */

int 
com_mListDeleteItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;

     DBUG_ENTER("mListDeleteItems");  

     if (argc != 4) 
	 {
	 argcError("mListDeleteItems","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeleteItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("mListDeleteItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListDeleteItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItems(localVar1,localVar2,localVar3);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItemsPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# number of items
 * 	in: int			# position of first item to be deleted
 */

int 
com_mListDeleteItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("mListDeleteItemsPos");  

     if (argc != 4) 
	 {
	 argcError("mListDeleteItemsPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeleteItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListDeleteItemsPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListDeleteItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeleteItemsPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeletePos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

int 
com_mListDeletePos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mListDeletePos");  

     if (argc != 3) 
	 {
	 argcError("mListDeletePos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeletePos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListDeletePos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeletePos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectAllItems
 * 	in: XmListWidget	# List Widget
 */

int 
com_mListDeselectAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mListDeselectAllItems");  

     if (argc != 2) 
	 {
	 argcError("mListDeselectAllItems","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeselectAllItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectItem
 * 	in: XmListWidget	# List Widget	
 * 	in: XmString		# item
 */

int 
com_mListDeselectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mListDeselectItem");  

     if (argc != 3) 
	 {
	 argcError("mListDeselectItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeselectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListDeselectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

int 
com_mListDeselectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mListDeselectPos");  

     if (argc != 3) 
	 {
	 argcError("mListDeselectPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListDeselectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListDeselectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListDeselectPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean                          
 * XmListGetMatchPos
 * 	in: XmListWidget	# List Widget   
 * 	in: XmString		# item
 * 	out: list(int*,int)	# list of positions
 */

int 
com_mListGetMatchPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int* localVar3list;
     int localVar3count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mListGetMatchPos");  

     if (argc != 4) 
	 {
	 argcError("mListGetMatchPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListGetMatchPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListGetMatchPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetMatchPos(localVar1,localVar2,&localVar3list, &localVar3count);
     XmStringFree(localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[3], intsToTcl(localVar3count,localVar3list), 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListGetSelectedPos
 * 	in: XmListWidget	# List Widget
 * 	out: list(int*,int)     # list of highlighted items
 */

int 
com_mListGetSelectedPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int* localVar2list;
     int localVar2count;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mListGetSelectedPos");  

     if (argc != 3) 
	 {
	 argcError("mListGetSelectedPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListGetSelectedPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListGetSelectedPos(localVar1,&localVar2list, &localVar2count);

     
     Tcl_SetVar(wafeInterpreter, argv[2], intsToTcl(localVar2count,localVar2list), 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListItemExists
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

int 
com_mListItemExists(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mListItemExists");  

     if (argc != 3) 
	 {
	 argcError("mListItemExists","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListItemExists","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListItemExists","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemExists(localVar1,localVar2);
     XmStringFree(localVar2);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmListItemPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

int 
com_mListItemPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mListItemPos");  

     if (argc != 3) 
	 {
	 argcError("mListItemPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListItemPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListItemPos","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmListItemPos(localVar1,localVar2);
     XmStringFree(localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# Items to be replaced
 * 	in: int			# number of items to be replaced
 * 	in: XmStringTable	# new items
 */

int 
com_mListReplaceItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     XmStringTable localVar4;

     DBUG_ENTER("mListReplaceItems");  

     if (argc != 5) 
	 {
	 argcError("mListReplaceItems","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListReplaceItems","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("mListReplaceItems","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListReplaceItems","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar4 = (XmStringTable) stringToXmStringTable(argv[4])))
          {
          convError("mListReplaceItems","4",argv[4],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItems(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);
     freeStringTable(localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItemsPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# New items
 * 	in: int			# number of items to be replaced
 * 	in: int 		# first Pos of items to be replaced
 */

int 
com_mListReplaceItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("mListReplaceItemsPos");  

     if (argc != 5) 
	 {
	 argcError("mListReplaceItemsPos","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListReplaceItemsPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmStringTable) stringToXmStringTable(argv[2])))
          {
          convError("mListReplaceItemsPos","2",argv[2],"XmStringTable");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mListReplaceItemsPos","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("mListReplaceItemsPos","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListReplaceItemsPos(localVar1,localVar2,localVar3,localVar4);
     freeStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# item to highlight
 * 	in: Boolean		# Invoke callback yes/no
 */

int 
com_mListSelectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean localVar3;

     DBUG_ENTER("mListSelectItem");  

     if (argc != 4) 
	 {
	 argcError("mListSelectItem","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSelectItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListSelectItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mListSelectItem","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectPos
 * 	in: XmListWidget	# List Widget
 * 	in: int			# Position of item 
 * 	in: Boolean		# Invoke callback yes/no
 */

int 
com_mListSelectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean localVar3;

     DBUG_ENTER("mListSelectPos");  

     if (argc != 4) 
	 {
	 argcError("mListSelectPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSelectPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListSelectPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mListSelectPos","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSelectPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetAddMode
 * 	in: XmListWidget 	# List Widget
 * 	in: Boolean		# Use Add Mode yes/no
 */

int 
com_mListSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mListSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("mListSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetAddMode","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mListSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmListSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomItem	
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item to be displayed as last item
 */

int 
com_mListSetBottomItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mListSetBottomItem");  

     if (argc != 3) 
	 {
	 argcError("mListSetBottomItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetBottomItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListSetBottomItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# item to be displayed as last item
 */

int 
com_mListSetBottomPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mListSetBottomPos");  

     if (argc != 3) 
	 {
	 argcError("mListSetBottomPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetBottomPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListSetBottomPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetBottomPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetHorizPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# horizontal Position
 */

int 
com_mListSetHorizPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mListSetHorizPos");  

     if (argc != 3) 
	 {
	 argcError("mListSetHorizPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetHorizPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListSetHorizPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetHorizPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetItem
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item
 */

int 
com_mListSetItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mListSetItem");  

     if (argc != 3) 
	 {
	 argcError("mListSetItem","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetItem","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mListSetItem","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# Position
 */

int 
com_mListSetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mListSetPos");  

     if (argc != 3) 
	 {
	 argcError("mListSetPos","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
          {
          convError("mListSetPos","1",argv[1],"XmListWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mListSetPos","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmListSetPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MainW.h>
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

int 
com_mMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER("mMainWindowSetAreas");  

     if (argc != 7) 
	 {
	 argcError("mMainWindowSetAreas","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "NULL")) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mMainWindowSetAreas","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("mMainWindowSetAreas","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("mMainWindowSetAreas","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
          {
          convError("mMainWindowSetAreas","4",argv[4],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("mMainWindowSetAreas","5",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "NULL")) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
          {
          convError("mMainWindowSetAreas","6",argv[6],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
/* 
 * Widget
 * XmMessageBoxGetChild
 * 	in: XmMessageBoxWidget		# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

int 
com_mMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mMessageBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("mMessageBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmMessageBoxWidgetClass,"XmMessageBox")))
          {
          convError("mMessageBoxGetChild","1",argv[1],"XmMessageBoxWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("mMessageBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmMessageBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, widget2Name(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
/* 
 * void
 * XmScrollBarGetValues 
 * 	in: XmScrollBarWidget		# scrollbar widget
 * 	out: int	      		# value (slider position)
 *         out: int              		# slider size
 * 	out: int              		# increment (smallest movement)
 * 	out: int              		# page increment
 */

int 
com_mScrollBarGetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("mScrollBarGetValues");  

     if (argc != 6) 
	 {
	 argcError("mScrollBarGetValues","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          convError("mScrollBarGetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmScrollBarGetValues(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar5);
     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmScrollBarSetValues 
 * 	in: XmScrollBarWidget 		# scrollbar widget
 * 	in: int	              		# value (slider position)
 *         in: int               		# slider size
 * 	in: int               		# increment (smallest movement)
 * 	in: int               		# page increment 
 * 	in: Boolean           		# notify
 */

int 
com_mScrollBarSetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     Boolean localVar6;

     DBUG_ENTER("mScrollBarSetValues");  

     if (argc != 7) 
	 {
	 argcError("mScrollBarSetValues","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
          {
          convError("mScrollBarSetValues","1",argv[1],"XmScrollBarWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mScrollBarSetValues","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("mScrollBarSetValues","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("mScrollBarSetValues","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("mScrollBarSetValues","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
         {
         convError("mScrollBarSetValues","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmScrollBarSetValues(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
/* 
 * void
 * XmTextClearSelection
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_mTextClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextClearSelection");  

     if (argc != 2) 
	 {
	 argcError("mTextClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextClearSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCopy
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_mTextCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextCopy");  

     if (argc != 2) 
	 {
	 argcError("mTextCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextCopy","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextCut
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

int 
com_mTextCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextCut");  

     if (argc != 2) 
	 {
	 argcError("mTextCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextCut","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/TextF.h>
/* 
 * void
 * XmTextFieldClearSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	const: time(NULL)
 */

int 
com_mTextFieldClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextFieldClearSelection");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldClearSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldClearSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCopy
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

int 
com_mTextFieldCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextFieldCopy");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldCopy","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldCopy","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCopy(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldCut
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

int 
com_mTextFieldCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextFieldCut");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldCut","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldCut","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldCut(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextFieldGetBaseline
 * 	in: XmTextFieldWidget 		# Text field widget
 */

int 
com_mTextFieldGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextFieldGetBaseline");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldGetBaseline","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextFieldGetLastPosition
 * 	in: XmTextFieldWidget 		# Text field widget
 */

int 
com_mTextFieldGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextFieldGetLastPosition");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldGetLastPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextFieldGetSelection
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

int 
com_mTextFieldGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("mTextFieldGetSelection");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldGetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldGetSelectionPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

int 
com_mTextFieldGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextFieldGetSelectionPosition");  

     if (argc != 4) 
	 {
	 argcError("mTextFieldGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldGetSelectionPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldInsert
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

int 
com_mTextFieldInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("mTextFieldInsert");  

     if (argc != 4) 
	 {
	 argcError("mTextFieldInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldInsert","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextFieldInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldPaste
 * 	in: XmTextFieldWidget 	# Text field widget
 */

int 
com_mTextFieldPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextFieldPaste");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldPaste","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldPosToXY
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

int 
com_mTextFieldPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextFieldPosToXY");  

     if (argc != 5) 
	 {
	 argcError("mTextFieldPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldPosToXY","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldRemove
 * 	in: XmTextFieldWidget 	# Text field widget
 */

int 
com_mTextFieldRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextFieldRemove");  

     if (argc != 2) 
	 {
	 argcError("mTextFieldRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldRemove","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextFieldRemove(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldReplace
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

int 
com_mTextFieldReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("mTextFieldReplace");  

     if (argc != 5) 
	 {
	 argcError("mTextFieldReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldReplace","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextFieldReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextFieldReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetAddMode
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Boolean		# true | false
 */

int 
com_mTextFieldSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mTextFieldSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("mTextFieldSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldSetAddMode","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mTextFieldSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetHighlight
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

int 
com_mTextFieldSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("mTextFieldSetHighlight");  

     if (argc != 5) 
	 {
	 argcError("mTextFieldSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldSetHighlight","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextFieldSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         convError("mTextFieldSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

int 
com_mTextFieldSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("mTextFieldSetSelection");  

     if (argc != 4) 
	 {
	 argcError("mTextFieldSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldSetSelection","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextFieldSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldShowPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position to display
 */

int 
com_mTextFieldShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("mTextFieldShowPosition");  

     if (argc != 3) 
	 {
	 argcError("mTextFieldShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldShowPosition","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextFieldShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldXYToPos
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

int 
com_mTextFieldXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("mTextFieldXYToPos");  

     if (argc != 4) 
	 {
	 argcError("mTextFieldXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
          {
          convError("mTextFieldXYToPos","1",argv[1],"XmTextFieldWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("mTextFieldXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("mTextFieldXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextFieldXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextGetBaseline
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_mTextGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextGetBaseline");  

     if (argc != 2) 
	 {
	 argcError("mTextGetBaseline","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextGetBaseline","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextGetLastPosition
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_mTextGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextGetLastPosition");  

     if (argc != 2) 
	 {
	 argcError("mTextGetLastPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextGetLastPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XmTextGetSelection
 * 	in: XmTextWidget 	# Text widget
 * 	end: if (!returnVar) XtFree(returnVar);
 */

int 
com_mTextGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("mTextGetSelection");  

     if (argc != 2) 
	 {
	 argcError("mTextGetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextGetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelection(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     if (!returnVar) XtFree(returnVar);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextGetSelectionPosition
 * 	in: XmTextWidget 	# Text widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

int 
com_mTextGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextGetSelectionPosition");  

     if (argc != 4) 
	 {
	 argcError("mTextGetSelectionPosition","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextGetSelectionPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextInsert
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

int 
com_mTextInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("mTextInsert");  

     if (argc != 4) 
	 {
	 argcError("mTextInsert","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextInsert","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextInsert","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextPaste
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_mTextPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mTextPaste");  

     if (argc != 2) 
	 {
	 argcError("mTextPaste","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextPaste","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextPaste(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextPosToXY
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

int 
com_mTextPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextPosToXY");  

     if (argc != 5) 
	 {
	 argcError("mTextPosToXY","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextPosToXY","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextPosToXY","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextRemove
 * 	in: XmTextWidget 	# Text widget
 */

int 
com_mTextRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mTextRemove");  

     if (argc != 2) 
	 {
	 argcError("mTextRemove","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextRemove","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmTextRemove(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextReplace
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

int 
com_mTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("mTextReplace");  

     if (argc != 5) 
	 {
	 argcError("mTextReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextReplace","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextReplace","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextReplace","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextScroll
 * 	in: XmTextWidget 	# Text widget
 * 	in: int			# number of lines to scroll
 */

int 
com_mTextScroll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("mTextScroll");  

     if (argc != 3) 
	 {
	 argcError("mTextScroll","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextScroll","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("mTextScroll","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextScroll(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetAddMode
 * 	in: XmTextWidget 	# Text widget
 * 	in: Boolean		# true | false
 */

int 
com_mTextSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mTextSetAddMode");  

     if (argc != 3) 
	 {
	 argcError("mTextSetAddMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextSetAddMode","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mTextSetAddMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetHighlight
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# NORMAL | SELECTED | SECONDARY_SELECTED
 */

int 
com_mTextSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER("mTextSetHighlight");  

     if (argc != 5) 
	 {
	 argcError("mTextSetHighlight","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextSetHighlight","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextSetHighlight","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextSetHighlight","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         convError("mTextSetHighlight","4",argv[4],"XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetSelection
 * 	in: XmTextWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

int 
com_mTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER("mTextSetSelection");  

     if (argc != 4) 
	 {
	 argcError("mTextSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextSetSelection","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextSetSelection","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("mTextSetSelection","3",argv[3],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextShowPosition
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position to display
 */

int 
com_mTextShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER("mTextShowPosition");  

     if (argc != 3) 
	 {
	 argcError("mTextShowPosition","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextShowPosition","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("mTextShowPosition","2",argv[2],"XmTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextXYToPos
 * 	in: XmTextWidget 	# Text widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

int 
com_mTextXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("mTextXYToPos");  

     if (argc != 4) 
	 {
	 argcError("mTextXYToPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
          {
          convError("mTextXYToPos","1",argv[1],"XmTextWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("mTextXYToPos","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("mTextXYToPos","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XmTextXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleB.h>
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 */

int 
com_mToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mToggleButtonGetState");  

     if (argc != 2) 
	 {
	 argcError("mToggleButtonGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          convError("mToggleButtonGetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonSetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

int 
com_mToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("mToggleButtonSetState");  

     if (argc != 4) 
	 {
	 argcError("mToggleButtonSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
          {
          convError("mToggleButtonSetState","1",argv[1],"XmToggleButtonWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mToggleButtonSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mToggleButtonSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleBG.h>
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: XmToggleButtonGadget	# toggle button widget
 */

int 
com_mToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mToggleButtonGadgetGetState");  

     if (argc != 2) 
	 {
	 argcError("mToggleButtonGadgetGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          convError("mToggleButtonGadgetGetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGadgetGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

int 
com_mToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("mToggleButtonGadgetSetState");  

     if (argc != 4) 
	 {
	 argcError("mToggleButtonGadgetSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
          {
          convError("mToggleButtonGadgetSetState","1",argv[1],"XmToggleButtonGadget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mToggleButtonGadgetSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mToggleButtonGadgetSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmAddTabGroup
 * 	in: Widget        		# widget to be added
 */

int 
com_mAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mAddTabGroup");  

     if (argc != 2) 
	 {
	 argcError("mAddTabGroup","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mAddTabGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XmGen()
{
#ifdef MOTIF11
 createWidgetCommand("mArrowButton",xmArrowButtonWidgetClass,NULL,False);
 createWidgetCommand("mArrowButtonGadget",xmArrowButtonGadgetClass,NULL,False);
 createWidgetCommand("mBulletinBoard",xmBulletinBoardWidgetClass,NULL,False);
 createWidgetCommand("mBulletinBoardDialog",xmBulletinBoardWidgetClass,XmCreateBulletinBoardDialog,True);
 createWidgetCommand("mCascadeButton",xmCascadeButtonWidgetClass,NULL,False);
 createWidgetCommand("mCascadeButtonGadget",xmCascadeButtonGadgetClass,NULL,False);
 createWidgetCommand("mCommand",xmCommandWidgetClass,NULL,False);
 createWidgetCommand("mDialogShell",xmDialogShellWidgetClass,NULL,True);
 createWidgetCommand("mDrawingArea",xmDrawingAreaWidgetClass,NULL,False);
 createWidgetCommand("mDrawnButton",xmDrawnButtonWidgetClass,NULL,False);
 createWidgetCommand("mFileSelectionBox",xmFileSelectionBoxWidgetClass,NULL,False);
 createWidgetCommand("mFileSelectionDialog",xmFileSelectionBoxWidgetClass,XmCreateFileSelectionDialog,True);
 createWidgetCommand("mForm",xmFormWidgetClass,NULL,False);
 createWidgetCommand("mFormDialog",xmFormWidgetClass,XmCreateFormDialog,True);
 createWidgetCommand("mFrame",xmFrameWidgetClass,NULL,False);
 createWidgetCommand("mInformationDialog",xmMessageBoxWidgetClass,XmCreateInformationDialog,True);
 createWidgetCommand("mLabel",xmLabelWidgetClass,NULL,False);
 createWidgetCommand("mLabelGadget",xmLabelGadgetClass,NULL,False);
 createWidgetCommand("mList",xmListWidgetClass,NULL,False);
 createWidgetCommand("mMainWindow",xmMainWindowWidgetClass,NULL,False);
 createWidgetCommand("mMenuBar",xmRowColumnWidgetClass,XmCreateMenuBar,False);
 createWidgetCommand("mMenuShell",xmMenuShellWidgetClass,NULL,True);
 createWidgetCommand("mMessageBox",xmMessageBoxWidgetClass,NULL,False);
 createWidgetCommand("mMessageDialog",xmMessageBoxWidgetClass,XmCreateMessageDialog,True);
 createWidgetCommand("mOptionMenu",xmRowColumnWidgetClass,XmCreateOptionMenu,False);
 createWidgetCommand("mPanedWindow",xmPanedWindowWidgetClass,NULL,False);
 createWidgetCommand("mPopupMenu",xmRowColumnWidgetClass,XmCreatePopupMenu,False);
 createWidgetCommand("mPromptDialog",xmSelectionBoxWidgetClass,XmCreatePromptDialog,True);
 createWidgetCommand("mPulldownMenu",xmRowColumnWidgetClass,XmCreatePulldownMenu,False);
 createWidgetCommand("mPushButton",xmPushButtonWidgetClass,NULL,False);
 createWidgetCommand("mPushButtonGadget",xmPushButtonGadgetClass,NULL,False);
 createWidgetCommand("mQuestionDialog",xmMessageBoxWidgetClass,XmCreateQuestionDialog,True);
 createWidgetCommand("mRadioBox",xmRowColumnWidgetClass,XmCreateRadioBox,False);
 createWidgetCommand("mRowColumn",xmRowColumnWidgetClass,NULL,False);
 createWidgetCommand("mScale",xmScaleWidgetClass,NULL,False);
 createWidgetCommand("mScrollBar",xmScrollBarWidgetClass,NULL,False);
 createWidgetCommand("mScrolledList",xmListWidgetClass,XmCreateScrolledList,False);
 createWidgetCommand("mScrolledText",xmTextWidgetClass,XmCreateScrolledText,False);
 createWidgetCommand("mScrolledWindow",xmScrolledWindowWidgetClass,NULL,False);
 createWidgetCommand("mSelectionBox",xmSelectionBoxWidgetClass,NULL,False);
 createWidgetCommand("mSelectionDialog",xmSelectionBoxWidgetClass,XmCreateSelectionDialog,True);
 createWidgetCommand("mSeparator",xmSeparatorWidgetClass,NULL,False);
 createWidgetCommand("mSeparatorGadget",xmSeparatorGadgetClass,NULL,False);
 createWidgetCommand("mSimpleCheckBox",xmRowColumnWidgetClass,XmCreateSimpleCheckBox,False);
 createWidgetCommand("mSimpleMenuBar",xmRowColumnWidgetClass,XmCreateSimpleMenuBar,False);
 createWidgetCommand("mSimpleOptionMenu",xmRowColumnWidgetClass,XmCreateSimpleOptionMenu,False);
 createWidgetCommand("mSimplePopupMenu",xmRowColumnWidgetClass,XmCreateSimplePopupMenu,False);
 createWidgetCommand("mSimplePulldownMenu",xmRowColumnWidgetClass,XmCreateSimplePulldownMenu,False);
 createWidgetCommand("mSimpleRadioBox",xmRowColumnWidgetClass,XmCreateSimpleRadioBox,False);
 createWidgetCommand("mText",xmTextWidgetClass,NULL,False);
 createWidgetCommand("mTextField",xmTextFieldWidgetClass,NULL,False);
 createWidgetCommand("mToggleButton",xmToggleButtonWidgetClass,NULL,False);
 createWidgetCommand("mToggleButtonGadget",xmToggleButtonGadgetClass,NULL,False);
 createWidgetCommand("mWarningDialog",xmMessageBoxWidgetClass,XmCreateWarningDialog,True);
 createWidgetCommand("mWorkingDialog",xmMessageBoxWidgetClass,XmCreateWorkingDialog,True);
#ifdef MOTIF11
 strcat(wafePackages,"MOTIF11 ");
#endif
 XtSetTypeConverter(XtRString, "XmString",
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "XmStringTable",
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "Window",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "MenuWidget",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmString", XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmStringTable", XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 wafeMotifInit();
 qXmString = WafePermStringToQuark("XmString");
 qXmStringTable = WafePermStringToQuark("XmStringTable");
 qWindow = WafePermStringToQuark("Window");
 qHorizontalDimension = WafePermStringToQuark("HorizontalDimension");
 qVerticalDimension = WafePermStringToQuark("VerticalDimension");
 qTextPosition = WafePermStringToQuark("TextPosition");
 qPrimForegroundPixmap = WafePermStringToQuark("PrimForegroundPixmap");
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);
 Tcl_CreateCommand(wafeInterpreter, "mProcessTraversal", com_mProcessTraversal, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mCascadeButtonGadgetHighlight", com_mCascadeButtonGadgetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mCascadeButtonHighlight", com_mCascadeButtonHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mCommandAppendValue", com_mCommandAppendValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mCommandError", com_mCommandError, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mFileSelectionBoxGetChild", com_mFileSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mFileSelectionDoSearch", com_mFileSelectionDoSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListAddItem", com_mListAddItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListAddItems", com_mListAddItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListAddItemUnselected", com_mListAddItemUnselected, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeleteAllItems", com_mListDeleteAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeleteItem", com_mListDeleteItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeleteItems", com_mListDeleteItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeleteItemsPos", com_mListDeleteItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeletePos", com_mListDeletePos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeselectAllItems", com_mListDeselectAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeselectItem", com_mListDeselectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListDeselectPos", com_mListDeselectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListGetMatchPos", com_mListGetMatchPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListGetSelectedPos", com_mListGetSelectedPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListItemExists", com_mListItemExists, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListItemPos", com_mListItemPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListReplaceItems", com_mListReplaceItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListReplaceItemsPos", com_mListReplaceItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSelectItem", com_mListSelectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSelectPos", com_mListSelectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetAddMode", com_mListSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetBottomItem", com_mListSetBottomItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetBottomPos", com_mListSetBottomPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetHorizPos", com_mListSetHorizPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetItem", com_mListSetItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mListSetPos", com_mListSetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mMainWindowSetAreas", com_mMainWindowSetAreas, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mMessageBoxGetChild", com_mMessageBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mScrollBarGetValues", com_mScrollBarGetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mScrollBarSetValues", com_mScrollBarSetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextClearSelection", com_mTextClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextCopy", com_mTextCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextCut", com_mTextCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldClearSelection", com_mTextFieldClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldCopy", com_mTextFieldCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldCut", com_mTextFieldCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldGetBaseline", com_mTextFieldGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldGetLastPosition", com_mTextFieldGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldGetSelection", com_mTextFieldGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldGetSelectionPosition", com_mTextFieldGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldInsert", com_mTextFieldInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldPaste", com_mTextFieldPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldPosToXY", com_mTextFieldPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldRemove", com_mTextFieldRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldReplace", com_mTextFieldReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldSetAddMode", com_mTextFieldSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldSetHighlight", com_mTextFieldSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldSetSelection", com_mTextFieldSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldShowPosition", com_mTextFieldShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextFieldXYToPos", com_mTextFieldXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextGetBaseline", com_mTextGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextGetLastPosition", com_mTextGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextGetSelection", com_mTextGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextGetSelectionPosition", com_mTextGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextInsert", com_mTextInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextPaste", com_mTextPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextPosToXY", com_mTextPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextRemove", com_mTextRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextReplace", com_mTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextScroll", com_mTextScroll, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextSetAddMode", com_mTextSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextSetHighlight", com_mTextSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextSetSelection", com_mTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextShowPosition", com_mTextShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mTextXYToPos", com_mTextXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mToggleButtonGetState", com_mToggleButtonGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mToggleButtonSetState", com_mToggleButtonSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mToggleButtonGadgetGetState", com_mToggleButtonGadgetGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mToggleButtonGadgetSetState", com_mToggleButtonGadgetSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mAddTabGroup", com_mAddTabGroup, NULL, NULL);

#else
#endif
}
