set n 0

proc data {count} {
    if {$count<1} {return}

    global n
    for {set i 1} {$i<11} {incr i} {
	append data1 "$i/[expr 10+sin($i+$n)*$i] "
	append data2 "$i/[expr 10+cos($i-$n)*$i] "
	append data3 "[expr 10+sin($i+$n)*$i] "
	append data4 "[expr 10+cos($i-$n)*$i] "
    }
    eval xyLinePlotAttachData lp1 $data1
    eval xyLinePlotAttachData lp2 $data2
    eval barPlotAttachData    b1 $data3
    eval barPlotAttachData    b2 $data4
    set n [expr $n+0.5]
    addTimeOut 100 "data [expr $count-1]"
}

if ![isWidget f] {
  mergeResources topLevel {
    *XmPushButton.background gray80
    *leftAttachment ATTACH_WIDGET 
    *topAttachment ATTACH_WIDGET 
  }
  mForm f topLevel background gray50

  # first graph    
  plotter p1 f {
    height 200 width 300 title "XY Line Plot Example" usePixmap true
    background gray70 plotAreaColor gray90 showLegend false
  }
  xyAxis x p1               autoScale false min 0.5 max 10  drawGrid false
  xyAxis y p1 vertical true autoScale false min 0 max 19    drawGrid false
  sV p1 xAxis x yAxis y
  xyLinePlot lp1 p1 plotLineType lineimpulses
  xyLinePlot lp2 p1 plotLineType lineimpulses foreground red

  # buttons
  mPushButton quit f topWidget p1 activateCallback %w
  mPushButton go   f topWidget p1 leftWidget quit activateCallback "data 200"
  mPushButton source f topWidget p1 leftWidget go activateCallback "source m-xy.tcl"

  # second graph    
  plotter p2 f {
    height 200 width 300 title "Some Demo" usePixmap true
    background gray70 plotAreaColor gray90 showLegend false
    leftWidget p1
  }
  axis x2 p2 \
    drawSubgrid false numbersOutside true autoScale false min 0 max 13 
  axis y2 p2 vertical true drawSubgrid false drawFrame true
  sV p2 xAxis x2 yAxis y2
  
  barPlot b1 p2 fillColor yellow cellOffset -0.4 cellWidth 0.5 shading gray5
  barPlot b2 p2 fillColor green  cellOffset -0.15 cellWidth 0.5 shading gray3
    
  data 1
  realize
}
