#!/usr/bin/X11/wafe --f

proc prim {number} {
    for {set divisor 2} {$divisor <= $number} {} {
	if [expr $number%$divisor] { incr divisor } else {
	    lappend result $divisor
	    set number [expr $number/$divisor]
	}
    }
    sV result label [join $result *]
}

proc doEval {num} {
    if [regexp ^\[0-9\]+\$ $num] {
	if [catch {time {prim $num}} result] {
	    sV result label {}
	    sV info label {invalid input}
	} else {  
	    scan $result {%d %s} time junk
	    sV info label "[expr $time/1000] milliseconds"
	} 
    } else {
	sV result label {}
	sV info label {invalid input}
    }
}          

form top topLevel

asciiText input top \
    editType edit width 200 \
    translations {#override 
	<Key>Return: exec(sV info label "thinking..."; \
	                  addTimeOut 10 {doEval [gV input string]}) }

label result top \
    label {} width 200 fromVert input

command quit top \
    fromVert result callback quit

label info top \
    borderWidth 0 width 150 label {} \
    fromVert result fromHoriz quit 

realize
