#include <descrip.h>
#include <ssdef.h>   /* system service definitions */
#include <stdio.h>   /* the standard io stuff */
#include <iodef.h>   /* more io stuff */
#include <math.h>                         
#include "navstructs.c"
#include "setupascii.c"

main()
{
 /*load_arrays();*/  /*read in from ascii */

 /*save_the_world();*/

 load_binary();
}



/*******************************************************************
*  SAVE THE WORLD
*/
save_the_world()
{
   FILE *fp;
  int i, j;
            
/*  Open the data file for writing
*/                       

  fp = fopen("world.bin","w");
                       
  for(i=0;i<total_node_count;++i){ 
        fwrite (&world[i],sizeof(struct node),1,fp);
       }
  fclose(fp);

/*************************************************************
*
*   Save the picture set array.
*/

  fp = fopen("psets.bin","w");

  for(i=0;i<total_node_count;++i){
	 fwrite (&picture_sets[i],sizeof(struct pictureset),1,fp);
        }
  fclose(fp);


}





/***************************************************************************
*
*   Load up the WORLD.
*
***************************************************************************/

load_binary()
{
  FILE *fp;
  int i, j, p;
            
/*  Open the data file for reading
*/                       

  fp = fopen("world.bin","r");
  p = ftell(fp);

/*   Set up a counter and allocate space for the first node
*/                 

  i = 0;
  world[i] = calloc(1, sizeof(struct node) );

/*   Read in the node data to world[i], then increment counter, allocate
 *   space for the next node, and reenter the loop.
*/

  while (fread (&world[i],sizeof(struct node),1,fp) != 0 ) {
	    p = ftell(fp);
	    ++i;
            world[i] = calloc(1, sizeof(struct node) );
          }

/*  After all the nodes are in, set global total_node_count
*/

  total_node_count = i;
  free(world[i]);
  fclose(fp);


/*************************************************************
*
*   Load the picture set array.
*/

  fp = fopen("psets.bin","r");
  p = ftell(fp);
  i = 0;
  picture_sets[i] = calloc(1, sizeof(struct pictureset) );

/*   Read in the node data to picture_sets[i], then increment counter, allocate
 *   space for the next node, and reenter the loop.
*/

  while (fread(&picture_sets[i],sizeof(struct pictureset),1,fp) != 0){
	    p = ftell(fp);
	    ++i;
            picture_sets[i] = calloc(1, sizeof(struct pictureset) );
           }

/*  After all the nodes are in, set global total_node_count
*/


  free(picture_sets[i]);
  fclose(fp);
}





