
/*

sony.c - dumb callable version of ldp.c

Russ Sasnett 2/21/86

*/

#include <stdio.h>
#include <fcntl.h>
#include <sgtty.h>

#include "ldpcmds.h"

/* blocksize set for IBM */

#define DIE(x) { printf x; return(-1); }

char cmds[70][4];   /* array of single-byte commands */
static char *cmdfile = "ldpcmds";
#define MAXSTR 128

#define CMD(c) cmds[c][0]

int
sony_open( speed, pname )

	int speed;
	char pname[64];  /* name of port disc is connected to */
{
int tfd;
int cnt;
FILE *fp;
struct sgttyb fdbuf;

if( (fp = fopen("ldpcmds","r")) == NULL )
  DIE( ("\nunable to open file <ldpcmds>\n") );

/* read in array of byte commands */

cnt = 0;
while( !feof(fp) ) {
  fscanf( fp, "%02x %02x %02x %02x\n", 
	 &cmds[cnt][0],&cmds[cnt][1],&cmds[cnt][2],&cmds[cnt][3] );
  cnt++;
}
fclose(fp);

if( (tfd=open(pname,O_RDWR))<0 ) DIE( ("unable to open port\n") );
ioctl( tfd, TIOCGETP, &fdbuf );
switch( speed ) {
 case 9600:
  speed = B9600;
  break;
 case 4800:
  speed = B4800;
  break;
 default:
  speed = B9600;
  break;
}

fdbuf.sg_ispeed = speed;
fdbuf.sg_ospeed = speed;
fdbuf.sg_flags |= (RAW | ANYP );  /* raw data, no parity */
fdbuf.sg_flags &= ~ECHO;         /* no echoing (half-duplex) */
ioctl( tfd, TIOCSETP, &fdbuf );

send( tfd, CMD(CL) );
send( tfd, CMD(CE) );

return tfd;
}

int
sony_cmd( tfd, lbuf )

	int tfd;
	char *lbuf;
{
char c;
int i;
char strbuf[MAXSTR];
int p1, p2;
int pcount;
int slen;

  if( tfd < 0 ) DIE( ("SONY_CMD: device not open\n") );

  pcount = sscanf(lbuf,"%s %d %d",strbuf,&p1,&p2);
  if( pcount==EOF || pcount==0 ) return 0;

  if( !strcmp(strbuf,"still") )
    send( tfd, CMD(STILL) );
  else if( !strcmp(strbuf,"fplay") )
    send( tfd, CMD(FPLAY) );
  else if( !strcmp(strbuf,"rplay") )
    send( tfd, CMD(RPLAY) );
  else if( !strcmp(strbuf,"fslow") )
    send( tfd, CMD(FSLOW) );
  else if( !strcmp(strbuf,"rslow") )
    send( tfd, CMD(RSLOW) );
  else if( !strcmp(strbuf,"ffast") )
    send( tfd, CMD(FFAST) );
  else if( !strcmp(strbuf,"rfast") )
    send( tfd, CMD(RFAST) );
  else if( !strcmp(strbuf,"fscan") )
    send( tfd, CMD(FSCAN) );
  else if( !strcmp(strbuf,"rscan") )
    send( tfd, CMD(RSCAN) );
  else if( !strcmp(strbuf,"fstep") )
    send( tfd, CMD(FSTEP) );
  else if( !strcmp(strbuf,"rstep") )
    send( tfd, CMD(RSTEP) );
  else if( !strcmp(strbuf,"fstep1") )
    {
    send( tfd, CMD(FSTEP) );
    mpause(33);
    send( tfd, CMD(STILL) );
    }
  else if( !strcmp(strbuf,"rstep1") )
    {
    send( tfd, CMD(RSTEP) );
    mpause(33);
    send( tfd, CMD(STILL) );
    }
  else if( !strcmp(strbuf,"indexon") )
    send( tfd, CMD(INDEXON) );
  else if( !strcmp(strbuf,"indexoff") )
    send( tfd, CMD(INDEXOFF) );

  else if( !strcmp(strbuf,"search") ) {
	if( pcount != 2 ) {
		printf("SEARCH: needs 1 arg, got %d\n",pcount);
		return -1;
		}
    	send( tfd, CMD(SEARCH) );
	outframe( tfd, p1 );
	send( tfd, CMD(ENTER) );
	if( wait_reply( tfd, CMD(COMPLETION) ) ) printf("WAIT_REPLY: err\n");
	}	
  else if( !strcmp(strbuf,"segplay") ) {
	if( pcount != 3 ) {
		printf("SEGPLAY: needs 2 args, got %d\n",pcount);
		return -1;
		}
    	send( tfd, CMD(SEARCH) );
	outframe( tfd, p1 );
	send( tfd, CMD(ENTER) );
	wait_reply( tfd, CMD(COMPLETION) );	
	send( tfd, CMD(REPEAT) );
	outframe( tfd, p2 );
	send( tfd, CMD(ENTER) );
	send( tfd, CMD(ENTER) );
	if( wait_reply( tfd, CMD(COMPLETION) ) ) printf("wait_reply: err\n");
	}
  else printf("SONY: unrecognized command <%s>\n",lbuf);

  return 0;
}

int
sony_close(dev)
	int dev;
{
if( dev<0 ) DIE( ("SONY_CLOSE: device not open\n") );
close(dev);
return 0;
}

int
send( dev, c )

     int dev;
     char c;
{
char ack;
char timeout = 10;  /* ten reads */

  if( dev < 0 ) DIE( ("_SONY_send: device not open\n") );
  if( write(dev,&c,1) < 1 ) printf("write failed\n");
  /* wait for ACK */
  while( read(dev,&ack,1) < 1 && --timeout );
  if( timeout <= 0 ) printf("read timed out\n");
  if( ack!=CMD(ACK) ) printf("bad ack\n");
  return 0;
}

int
outframe( dev, num )

	int dev,num;
{
char frnum[10];
int i;

	if( dev < 0 ) DIE( ("SONY_outframe: device not open\n") );
	sprintf(frnum,"%05d",num);
	for( i=0; i<5; i++ ) send( dev, frnum[i] );
	return 0;
}

int
wait_reply( dev, code )

	int dev, code;
{
char c;

	if( dev < 0 ) DIE( ("SONY_wait_reply: device not open\n") );
	while( !read(dev,&c,1) );
	if( c != code ) return -1;
	else return 0;
}
