#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#define DISPLAYS
#include "dspdefs.h"
#define FN_MISC extern
#define SETPOS extern
#include "functions.h"
#define VDISC extern
#include "vdisc.h"

extern in_region();
extern Map *find_map();
extern struct maplist 	  *find_all_maps();

/*#define DBG             1 */
#ifdef DBG
#define Debug(f)	fprintf f
#else 
#define Debug(f)
#endif

/*-----------------------------------------------------------------------
*	Assumes w is invisible -- works up the tree mapping unmapped
*	parents until it finds a parent that is visible or the RootWindow.
*/

map_parents(w)
	Window	w;
{
	WindowInfo    info;
	int           nchildren;
	Window        parent;
	Window        *children;

      	if( w == (Window) NULL ) return (-1);
      	while( w != (Window) NULL && w != RootWindow ) 
	{
              	XQueryTree( w, &parent, &nchildren, &children );
              	free( (char *) children );
              	w = parent;
              	XQueryWindow( w, &info );
		if( info.mapped == IsUnmapped)
		{
			XMapWindow( (Window) w);
		 }
              	XQueryWindow( w, &info );
		if( ! info.mapped == IsInvisible)
		    break;

         }

	return(1);
}

/*-----------------------------------------------------------------------
*/
  void
free_video(e)
  Element	*e;
{
  static char   *funcname = "free_video";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, frame, zero = 0;
  float 	n, off;
  char		s[Nchars];
  Screenlist    *sl;

	/*  Special routine to "unmanaged" video control.*/

Debug((stderr,"  %s\n",funcname));
	sl = e->screen;
  	while(sl)
	{
 		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
        	if(info.mapped == IsUnmapped)
		{
			XMapWindow( (Window) sl->s->w);
	 	 }
  		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
  		if( info.mapped == IsInvisible )
  		{
			map_parents( sl->s->w );
	 	 }
		sl = sl->next;
	 }
}
/*------------------------------------------------------------------------
*/
  void
display_still(e)
  Element   	*e;
{
  static char   *funcname = "display_still";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, frame, zero = 0;
  float 	n, off;
  char		s[Nchars];
  Screenlist    *sl;
  int		pixmap[16];



	if(m->simple.out <= m->simple.in)
	{
		frame = m->simple.in;
	 }
	else
	{
		n = m->simple.out - m->simple.in;
		off = e->p->dimension[m->simple.key_dimension]->current 
		    + m->simple.in;
		frame = ( off/ n) * n;	
	 }

	if((status = Vdisc_search(frame,WAIT)) != 0)
	{
		fprintf(stderr,"%s: search frame `%d', status = %d\n",
		    funcname,frame,status);
		exit(1);
	 }
	sl = e->screen;
  	while(sl)
	{
 		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
        	if(info.mapped == IsUnmapped)
		{
			XMapWindow( (Window) sl->s->w);
	 	 }
  		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
  		if( info.mapped == IsInvisible )
  		{
			map_parents( sl->s->w );
	 	 }
Debug((stderr,"  XScaleVideo to 0,0,%d,%d in window %d\n",info.width,info.height,sl->s->w));
  		if((status = XScaleVideo(sl->s->w, 0, 0, 640, 480, 
				0, 0, info.width,info.height)) == -1)
		{
	  		printf("%s: failed XScaleVideo to 0,0,%d,%d in window %d\n",funcname,info.width,info.height,sl->s->w);
			exit(1);
	 	}
Debug((stderr,"  getpixmap.."));
		if((status = XPixmapGetXY(RootWindow,1,1,1,1,pixmap)) == -1)
		{
	  		printf("%s: failed XPixmapGet\n",funcname);
			exit(1);
	 	}
Debug((stderr,"done\n"));
		
		sl = sl->next;
	 }

	if( d->rate == 0 && d->rate_setting != 0)
	{
		d->rate = d->interval = d->rate_setting;
		start_timer(d, &zero, 0);
	 }
        
}


/*------------------------------------------------------------------------
*/
  CVideo        *cvideo;

  void
display_complex(e)
  Element   	*e;
{
  static char   *funcname = "display_complex";
  Map		*m = e->current;
  WindowInfo    info;
  int 		status;
  Screenlist    *sl;


  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }

	if( ! m->complex.cvideo )
	{
		if (!(m->complex.cvideo = InitCVideo(e->screen->s->w,
			info.width, info.height, disc->port, 
			m->complex.startframe, m->complex.rows,
	    		m->complex.columns, m->complex.offset, 
			m->complex.xoverlap, m->complex.yoverlap, 
			HORIZONTAL))) 
		{
			printf( "Could not init map.\n");
			exit(3);
	 	 }
	 }

	cvideo = m->complex.cvideo;  /* tmp: set global cvideo for proc */
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
	 }
  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }
		
        
}



/*--------------------------------------------------------------------
*/

#define Nspeeds 3
#define VDSC_STEP  1000 /* msec between frames */
#define VDSC_SLOW  165
#define VDSC_PLAY  33
#define VDSC_FAST  11


  int
play_vdisc(disc, d, m)
  Vdisc  	*disc;
  Dimension	*d;
  Map		*m;
{
  char		*func = "play_vdisc";
  char		s[Nchars];
  int		sign = d->rate_setting < 0 ? -1 : 1;
  struct timezone       tmz, *timezone = &tmz;
  int		i,status;
  static struct	spd{
			int	val;
			int	fwdcmd;
			int     revcmd;
		     }  speed[4] = {	VDSC_FAST, F_FAST, R_FAST,
			      		VDSC_PLAY, F_PLAY, R_PLAY,
			      		VDSC_SLOW, F_SLOW, R_SLOW
			      	      };

	for(i = 0; i < Nspeeds && speed[i].val < (d->rate_setting *sign);++i);

	if(i >= Nspeeds) i = Nspeeds - 1;
        if(sign < 0)
	{
		if((status = Vdisc_setspeed(speed[i].revcmd)) != 0)
		{
			fprintf(stderr,"%s: Vdisc_setspeed `%d'\n",
			    func,speed[i].revcmd);
			exit(1);
		 }
	 }
	else
	{
		if((status = Vdisc_setspeed(speed[i].fwdcmd)) != 0)
		{
			fprintf(stderr,"%s: Vdisc_setspeed `%d'\n",
			    func,speed[i].fwdcmd);
			exit(1);
		 }
	 }		

	gettimeofday(&d->start_time,timezone);

	d->start_point = d->current;
	d->interval = d->rate = d->rate_setting;

	d->rate = speed[i].val * sign;
	d->interval = speed[i].val;

	return (speed[i].val);
}

boundary_video(m,e,d,disc)
  Map		*m;
  Element	*e;
  Dimension	*d;
  Vdisc		*disc;
{
  char		*funcname = "boundary_video";
  char		s[Nchars];
  int 		n, status;
  WindowInfo    info;
  Screenlist    *sl;

Debug((stderr,"%s\n",funcname));

	switch(d->boundary)  /* Note: EXPIRE handled in setpos */
  	{
		case WRAP:
			disc->operation = VDSC_STOPPED;
			display_video(e);
			break;
		case FREEZE:
			if((status = Vdisc_still) != 0)
			{
			    fprintf(stderr,"%s: Vdisc_still,status %d\n",
		    		 funcname,status);
			    exit(1);
	 		 }
		  	if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->screen->s->w);
				exit(1);
	 		 }

			disc->operation = VDSC_STOPPED;
			break;
		case BOUNCE:
			d->rate_setting *= -1;
			if((status = Vdisc_audio1on) != 0)
			{
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    	     	    funcname,status);
			   	exit(1);
	 		 }
			if((status = Vdisc_audio1on) != 0)
			{
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    		     funcname,status);
			    	exit(1);
	 		  }
			if(e->selected == 1)
			{
			     if((status = Vdisc_audio1off) != 0)
			     {
			    	 fprintf(stderr,"%s: Vdisc_a1off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		      }
			 }
			if(e->selected == 2)
			{
			     if((status = Vdisc_audio2off) != 0)
			     {
			    	 fprintf(stderr,"%s: Vdisc_a2off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		      }
		 	 }
			n = play_vdisc(disc, d, m);
			if((status = XStartVideo(e->screen->s->w, 0,0,3)) == -1)
			{
				printf("%s: failed XStartVideo\n"
				    ,funcname);
				exit(1);
	 		 }		
			disc->operation = n;	
			break;
		case LIMIT:
			if((status = Vdisc_still) != 0)
			{
			    fprintf(stderr,"%s: Vdisc_still, status %d\n",
		    		 funcname,status);
			    exit(1);
	 		 }
		  	if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->screen->s->w);
				exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
			d->rate = d->rate_setting = 0;
			break;
	}
}


  void
display_video(e)
  Element   	*e;
{
  static char   *funcname = "display_video";
  Map		*m = e->current;
  static Map    *now_showing; /* keep track of map */
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, rate, rf, frame, k;
  float		n, off;
  char		s[Nchars];
  int		zero = 0;
  Screenlist    *sl;

Debug((stderr,"%s element ~%s'\n",funcname,e->name));
	
	m = find_map(e);
        if(m != now_showing) /* switch to new map if neccessary */
	{
		now_showing = m;
		disc->operation = VDSC_STOPPED;
	 }
Debug((stderr," found map `%d' ...",m));
  	if( in_region(e->p, m))
	{
Debug((stderr,"  in region...\n"));
   		if( disc->operation == VDSC_STOPPED || d->rate == 0 )
   		{
Debug((stderr,"   with disc stopped\n"));
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
        		if(info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) e->screen->s->w);
	 	 	 }
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
  			if( info.mapped == IsInvisible )
  			{
				map_parents( e->screen->s->w );
	 		 }
			n = m->simple.out - m->simple.in;
			k = m->simple.key_dimension;
		       off = e->p->dimension[k]->max - e->p->dimension[k]->min;
Debug((stderr,"   nframes %f, dimrange (off) %f..",n,off));
	if(n > off)
	{
		m->simple.out -= (n-off);
		printf("%s warning: framecount greater than dimension in element %s\n",funcname, e->name);
		printf("\treset to `%d'\n",m->simple.out);
	 }
			if (off != 0)
			{
				off = ((float) e->p->dimension[k]->current 
				    / off)*n;
Debug((stderr,"off %f\n",off));
				e->p->dimension[k]->delta_sign = (n>0)? 1: -1;

			 }


			if( off - (frame = off) > .5) ++frame;	       
		       frame += m->simple.in;
Debug((stderr,"  searching frame `%d'\n",frame));
			
			if((status = Vdisc_search(frame,WAIT)) != 0)
			{
			    fprintf(stderr,"%s: search frame `%d', status = %d"
		    	 	,funcname,frame,status);
			    exit(1);
	 		 }

  			if((status = XStillVideo(e->screen->s->w, 0, 0, 
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo to 0,0,%d,%d\n",
			    	    funcname,info.width,info.height);
				exit(1);
	 	 	 }

	 		if(d->rate_setting != 0)
			{
Debug((stderr," assigned control to pack %s,element %s\n",e->p->name,e->name));
				disc->controlling_element = e;
					/* Control can be taken if the disc is 
					*  stopped.
					*/
			    if((status = Vdisc_audio1on) != 0)
			    {
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    	     	    funcname,status);
			   	exit(1);
	 		     }
			    if((status = Vdisc_audio1on) != 0)
			    {
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    		     funcname,status);
			    	exit(1);
	 		     }
			    if(e->selected == 1)
			    {
			      if((status = Vdisc_audio1off) != 0)
			      {
			    	 fprintf(stderr,"%s: Vdisc_a1off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		       }
			     }
			    if(e->selected == 2)
			    {
			      if((status = Vdisc_audio2off) != 0)
			      {
			    	 fprintf(stderr,"%s: Vdisc_a2off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		       }
		 	     }
				n = play_vdisc(disc, d, m);
  				if((status = XStartVideo(e->screen->s->w, 0,0,3)) == -1)
				{
	  				printf("%s: failed XStartVideo\n"
					    ,funcname);
					exit(1);
	 			 }		
				disc->operation = n;
				stop_timer(d);

				start_timer(d, &zero, 0);
	 	 	 }
			else
			{
				disc->operation = VDSC_STOPPED;
				stop_timer(d);
				if((status = Vdisc_still) != 0)
				{
				    fprintf(stderr,"%s: Vdisc_still, status %d\n", funcname,status);
				    exit(1);
		 		 }
			 }

		 }
		else		/* disc is playing -- watch for end  */
		{
Debug((stderr,"  with disc playing\n"));

			if((     (d->rate < 0 && d->current == d->min)
			     ||  (d->rate > 0 && d->current == d->max))
			     &&  (disc->controlling_element == e)  )
			{
				boundary_video(m,e,d,disc);
			 }
		  }
    	 }
	else		/*  element is out of bounds  */
	{
Debug((stderr,"  out of bounds\n"));
		if( ! XQueryWindow(e->screen->s->w,&info))
		{
 			printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
 		 }

	        if(info.mapped == IsMapped)
		{
			XUnmapWindow( (Window) e->screen->s->w);
	 	 }
		if((     (d->rate < 0 && d->current == d->min)
		     ||  (d->rate > 0 && d->current == d->max))
		     &&  (disc->controlling_element == e)  )
		{
			if((status = Vdisc_still) != 0)
			{
			    fprintf(stderr,"%s: Vdisc_still,status %d\n",
		    		 funcname,status);
			    exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
		 }
	 }		
}

  void
display_audio(e)
  Element   	*e;
{
  static char   *funcname = "display_video";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  Screenlist    *sl;
  WindowInfo    info;
  int 		status, rate, rf, frame, k;
  float		n, off;
  char		s[Nchars];
  int		zero = 0;

Debug((stderr,"%s: element `%s'\n",funcname,e->name));
	
	m = find_map(e);
  	if( in_region(e->p, m))
	{
   		if( disc->operation == VDSC_STOPPED )
   		{
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
        		if(info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) e->screen->s->w);
	 	 	 }
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
  			if( info.mapped == IsInvisible )
  			{
				map_parents( e->screen->s->w );
	 		 }
			n = m->simple.out - m->simple.in;
			k = m->simple.key_dimension;
		       off = e->p->dimension[k]->max - e->p->dimension[k]->min;
	if(n > off)
	{
		m->simple.out -= (n-off);
		printf("%s warning: framecount greater than dimension in element %s\n",funcname, e->name);
		printf("\treset to `%d'\n",m->simple.out);
	 }
		        off = (off == 0) ? 0 : 
			  ((float) e->p->dimension[k]->current / off)*n;
			if( off - (frame = off) > .5) ++frame;	       
		       frame += m->simple.in;
			

	 		if(d->rate_setting != 0)
			{
printf(" assigned control to pack %s, element %s\n",e->p->name,e->name);
				disc->controlling_element = e;
					/* Control can be taken if the disc is 
					*  stopped.
					*/
			    if((status = Vdisc_audio1on) != 0)
			    {
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    	     	    funcname,status);
			   	exit(1);
	 		     }
			    if((status = Vdisc_audio1on) != 0)
			    {
				fprintf(stderr,"%s: Vdisc_a1on, status %d\n",
		    		     funcname,status);
			    	exit(1);
	 		     }
			    if(e->selected == 1)
			    {
			      if((status = Vdisc_audio1off) != 0)
			      {
			    	 fprintf(stderr,"%s: Vdisc_a1off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		       }
			     }
			    if(e->selected == 2)
			    {
			      if((status = Vdisc_audio2off) != 0)
			      {
			    	 fprintf(stderr,"%s: Vdisc_a2off, status %d\n",
		    		     funcname,status);
			    	 exit(1);
	 		       }
		 	     }
			     n = play_vdisc(disc, d, m);
			     disc->operation = n;
			     stop_timer(d);

			     start_timer(d, &zero, 0);
	 	 	 }
		 }
		else		/* disc is playing -- watch for end  */
		{
			if((     (d->rate < 0 && d->current == d->min)
			     ||  (d->rate > 0 && d->current == d->max))
			     &&  (disc->controlling_element == e)  )
			{
				boundary_video(m,e,d,disc);
			 }
		 }
    	 }
	else		/*  element is out of bounds  */
	{
	        if(info.mapped == IsMapped)
		{
			XUnmapWindow( (Window) m->simple.w);
	 	 }
		if((     (d->rate < 0 && d->current == d->min)
		     ||  (d->rate > 0 && d->current == d->max))
		     &&  (disc->controlling_element == e)  )
		{
			if((status = Vdisc_still) != 0)
			{
			    fprintf(stderr,"%s: Vdisc_still,status %d\n",
		    		 funcname,status);
			    exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
		 }
	 }		
}

/*-------------------------------------------------------------------
*   DISPLAY TEXT
*
*   This text handling routine works with a toolkit text widget.  The
*   widget pointer is hung on e->w, the element window slot.  The 
*   element carries the source file name.  The mappings hold byte
*   offsets into this file.  The mappings are non-overlapping in this
*   case; that is, only one of the mappings can be displayed at a time.
*/

  void
display_text(e)
  Element   	*e;
{
  static char   *funcname = "display_text";
  Map		*m;
  WindowInfo    info;
  Screenlist    *sl;
  int 		status;
  char		s[Nchars];
  float		n, off;
  int		k, offset;

Debug((stderr,"%s: element `%s', type %d\n",funcname,e->name,e->map->simple.type));

  	if( ! in_region(e->p, e->map)) 
	{
		XUnmapWindow(e->w);
		return;
	 }



	if( ! XQueryWindow(e->w,&info))
	{
  		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
       	if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->w);
 	 }
	if( ! XQueryWindow(e->w,&info))
	{
  		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
	if( info.mapped == IsInvisible )
	{
		map_parents( e->w );
 	 }
  
	m = find_map(e);

       	if (m) set_text_position( e->w, m->simple.in);
        else set_text_position( e->w, 0);
        
}

/*-----------------------------------------------------------------
*   DISPLAY TK WIDGET
*
*   The widget element allows concurrent mappings; more than one
*   widget in the set can be visible at a time.
*/

  void
display_TKwidget(e)
  Element   	*e;
{
  static char   *funcname = "display_TKwidget";
  WindowInfo    info;
  Screenlist    *sl;
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;


Debug((stderr,"%s: element `%s'\n",funcname,e->name));


 	maplist = (struct maplist *)find_all_maps(e);

        /*  Make sure the target window is mapped... */
  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
	 }
	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }



  	while( maplist != 0 && maplist->map != 0)
  	{
Debug((stderr,"  `%d'",maplist->map));
	        /* see if item on maplist is currently mapped */
		for(tmp = e->mapped_widgets; tmp && tmp->map != maplist->map; 
		    tmp = tmp->next);  
		if( tmp)  /* if yes,  */
		{
Debug((stderr, " mapped already (type `%d')\n"
    ,tmp->map->simple.type,tmp->map));
			/*  remove from element list... */
			if(tmp->prev) tmp->prev->next = tmp->next;
			if(tmp->next) tmp->next->prev = tmp->prev;
			if(tmp == e->mapped_widgets) e->mapped_widgets = tmp->next;
			/*  and add to newlist   */
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		else
		{	/* otherwise map it...  */
Debug((stderr, " new mapping: type `%d'\n",
    maplist->map->simple.type,maplist->map));

  			if( !XMapWindow( (Window) maplist->map->simple.w))
			{
	  			printf("%s: failed XMapWindow\n", funcname);
				exit(1);
	 	 	 }
			if((tmp = (Mapped_items *)
			    calloc(1, sizeof(Mapped_items))) == 0)
			{
	  			printf("%s: failed calloc mapped_widgets\n"
				    ,funcname);
				exit(1);
			 }
			/*  and add it to newlist.  */
			tmp->map = maplist->map;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		maplist = maplist->next;			
	  }

	while( e->mapped_widgets != 0)
	{
		/* then unmap any that are up but shouldn't be */
Debug((stderr, "  unmapping: type `%d' at `%d'\n"
    ,e->mapped_widgets->map->simple.type,e->mapped_widgets->map));

		if( !XUnmapWindow( (Window) e->mapped_widgets->map->simple.w))
		{
			printf("%s: failed XUnmapWindow\n", funcname);
			exit(1);
	 	 }
		tmp = e->mapped_widgets;
		e->mapped_widgets = e->mapped_widgets->next;
		free(tmp);
	  }
        e->mapped_widgets = 0;
	if(newlist) e->mapped_widgets = newlist;
	XFlush();


        
}




/*----------------------------------------------------------------------
*   Draw Label  
*/
  void
draw_label(e,m,mode)
  Element 	*e;
  Map	 	*m;
  int		mode;
{

	int 		charpad = 0, spacepad = 0;  /* args to XLine, p 19 */
	int		func = GXcopy;  /* drawing mode, see X man p. 18 */
	WindowInfo    	info;
	static 	char  	*funcname = "draw_label";
  	char		*str;  		/* string to print */
	int		x,y, color;
	int		erase_before_draw = m->graphic.erase ? 0 : 1;
	Font    	font = m->graphic.font->id;



  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
	 }
	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }

	/*  If the label is to be wiped permanently (mode == ERASE), or
	*   if it is to be erased before a new copy is drawn (erase_befo...),
	*   then get rid of it by setting the color to zero.  Need to find
	*   a better way of doing this -- setting to 0 is baloney.
	*/
	if(mode == ERASE || erase_before_draw)
	{
		str = m->graphic.label;
		x = m->graphic.value[X1INDX];
		y = m->graphic.value[Y1INDX];
		color = 0;
		XTextMaskPad(	e->screen->s->w,
				x,y,
				str,strlen(str),
		        	font,
				charpad,spacepad,
				color,
				func,
				AllPlanes);

	 }

	/*  Mode ERASE is used to get rid of the label altogether; don't 
	*   redraw anything.  Therefore,...
	*/
	if(mode == ERASE) return; /* since the rest has to do with redraw */


	/*  If a label function has been declared, use it to get the string;
	*   otherwise use what's in the label slot.  Same goes for the
	*   location.
	*/
	str = m->graphic.label_fn ?
		       (char *)(*m->graphic.label_fn)(m,m->graphic.label_prm) :
			m->graphic.label;  

	/*  Note the function pointers for x and y are kept in an array,
	*   indexed by X1INDX, Y1INDX, X2INDX, and Y2INDX.  Values likewise.
	*/
	x = m->graphic.fn[X1INDX] ? /* fn or value? */
			(*m->graphic.fn[X1INDX])(m->graphic.params[X1INDX]) :
			m->graphic.value[X1INDX];  /* value  */

	y = m->graphic.fn[Y1INDX] ? /* fn or value? */
			(*m->graphic.fn[Y1INDX])(m->graphic.params[Y1INDX]) :
			m->graphic.value[Y1INDX];  /* value  */
		
	color = m->graphic.color;  /* integer foreground, see X, p.34 */

	/*  If there is no string, just bail out.  There should be a case for
	*   when there is no change; currently, the label blinks if it is
	*   set erase_before_draw, erasing and redrawing the same thing.
	*/
	if(!strlen(str)) return;

	XTextMaskPad(	e->screen->s->w,
			x,y,
			str,strlen(str),
		        font,
			charpad,spacepad,
			color,
			func,
			AllPlanes);

	XFlush();  
}

/*----------------------------------------------------------------------
*   Display Graphic
*/
  void
display_graphic(e)
  Element 	*e;
{
  	Map	*m = e->current ? e->current : e->map;
printf("display_graphic\n");
	switch(m->simple.type)
	{
		  case LINE_MAP:
			break;
		  case LABEL_MAP:
					/* options are DRAW and ERASE
					*  use ERASE to get rid of the 
					*  thing permanently.
					*/
			draw_label(e,m,DRAW);
			break;
		  case ARC_MAP:
			break;
		  case BOX_MAP:
			break;
		  default:
			break;
	 }
}


/*---------------------------------------------------------------------
*    Display  Package
*/
   void
display_package(e)
    Element 	*e;
{
  static char   *funcname = "display_package";
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;

 	maplist = (struct maplist *)find_all_maps(e);

  	while( maplist != 0 && maplist->map != 0)
  	{
	        /* see if 1st item on maplist is currently mapped */
		for(tmp = e->mapped_packages; tmp && tmp->map != maplist->map; 
		    tmp = tmp->next);  
		if( tmp)  /* if yes,  */
		{
Debug((stderr, "  mapped already type `%d' at `%d'\n"
    ,tmp->map->simple.type,tmp->map));
			/*  remove from element list... */
			if(tmp->prev) tmp->prev->next = tmp->next;
			if(tmp->next) tmp->next->prev = tmp->prev;
			if(tmp == e->mapped_packages)
			{
				 e->mapped_packages = tmp->next;
			 }
			/*  and add to newlist   */
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		else
		{	/* otherwise map it...  */
Debug((stderr, "  new activation: type `%d' at `%d'\n",
    maplist->map->simple.type,maplist->map));

			activate_package(maplist->map->simple.package);

			if((tmp = (Mapped_items *)
			    calloc(1, sizeof(Mapped_items))) == 0)
			{
	  			printf("%s: failed calloc mapped_packages\n"
				    ,funcname);
				exit(1);
			 }
			/*  and add it to newlist.  */
			tmp->map = maplist->map;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		maplist = maplist->next;			
	  }
	while( e->mapped_packages != 0)
	{
		/* then unmap any that are up but shouldn't be */
Debug((stderr, "  unmapping: type `%d' at `%d'\n"
    ,e->mapped_packages->map->simple.type,e->mapped_packages->map));

		expire(e->mapped_packages->map->simple.package,(Package *) 0,
		    DO_STOP);

		tmp = e->mapped_packages;
		e->mapped_packages = e->mapped_packages->next;
		free(tmp);
	        e->mapped_packages = 0;
	  }
	if(newlist) e->mapped_packages = newlist;
	XFlush();        
}

/********************************************************************
*  Display Action
*/
   void
display_action(e)
   Element	*e;
{
  static char   *funcname = "display_action";
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;

Debug((stderr,"%s:\n",funcname));
 	maplist = (struct maplist *)find_all_maps(e);

  	while( maplist != 0 && maplist->map != 0)
  	{
		m = maplist->map;
		(*m->simple.action)(m->simple.arg);
		maplist = maplist->next;			
	 }

}

