
#include <stdio.h>
#include "video_conf.h"
#include "rpd_driver.h"

extern char *getenv();

VCONF_DEVTABLE	vdt;	/* video device table */

main()
{
RPD_ptr	rpd;
int	rpd_index;
int	res;
char	cmd[64];
int	i,f1,f2;

	if( vconf_get_table( getenv("DISPLAY"), 
		VCONF_FILENAME, &vdt ) != VCONF_AOK )
			exit(1);
	
	if( (rpd_index = vconf_find_default_rpd( &vdt )) < 0 )
	{
		fprintf(stderr,"unable to find default rpd\n");
		exit(1);
	}

	if( (rpd = rpdutil_open( &vdt, rpd_index )) == NULL )
	{
		fprintf(stderr,"unable to open rpd %s on %s\n",
			rpd->devname, rpd->port );
		exit(1);
	}

	while(1)
	{
		printf("command? ");
		gets(cmd);
		if( !strcmp(cmd,"quit") )
			exit(0);
		
		if( !strcmp(cmd,"indexon") )
			res =	(*rpd->cmd)(rpd,INDEX_ON);
		else if( !strcmp(cmd,"indexoff") )
			res =	(*rpd->cmd)(rpd,INDEX_OFF);

		else if( !strcmp(cmd,"@") )
			printf("@ %d\n",(*rpd->getframe)(rpd));

		else if( !strcmp(cmd,"fjog") )
			res =	(*rpd->jog)(rpd,1);
		else if( !strcmp(cmd,"rjog") )
			res =	(*rpd->jog)(rpd,-1);

		else if( !strcmp(cmd,"reset") )
			res =	(*rpd->reset)(rpd);

		else if( !strcmp(cmd,"ffast") )
			res =	(*rpd->varspeed)(rpd,F_FAST);
		else if( !strcmp(cmd,"rfast") )
			res =	(*rpd->varspeed)(rpd,R_FAST);
		else if( !strcmp(cmd,"fplay") )
			res =	(*rpd->varspeed)(rpd,F_PLAY);
		else if( !strcmp(cmd,"rplay") )
			res =	(*rpd->varspeed)(rpd,R_PLAY);
		else if( !strcmp(cmd,"fslow") )
			res =	(*rpd->varspeed)(rpd,F_SLOW);
		else if( !strcmp(cmd,"rslow") )
			res =	(*rpd->varspeed)(rpd,R_SLOW);
		else if( !strcmp(cmd,"still") )
			res =	(*rpd->varspeed)(rpd,STOP);

		else if( !strcmp(cmd,"segplay") )
		{
			printf("from? ");
			gets(cmd);
			f1 = atoi(cmd);
			printf("to? ");	
			gets(cmd);
			f2 = atoi(cmd);
			res =	(*rpd->segplay)(rpd,f1,f2,1);
		}

		else if( !strcmp(cmd,"search") )
		{
			printf("to? ");
			gets(cmd);
			if( (i=atoi(cmd)) )
				res =	(*rpd->search)(rpd,i,1);
		}
 
		else printf("no such command.\n");

		printf("result of command is %d\n",res);
	}

	
}

