
#ifndef DISKMEM
#define DISKMEM

#include "ev_tokens.h"
#include "MemAssoc.h"

typedef struct
{
	int	flags;		/* used by FA */
	long	Cdeclarations;	/* head of list of C declarations */
	long	EnvHead;	/* head of list of environments */
} DM_HDR;

typedef short	STRING_HDR;	/* holds number of bytes in string that follows */

long 		dm_PutString();
char *		dm_GetString();
int		dm_FreeString();

long 		dm_PutVarList();
VAR_PTR		dm_GetVarList();
int		dm_FreeVarList();

long		dm_PutCdecList();
C_DCL_PTR	dm_GetCdecList();
int		dm_FreeCdecList();

long		dm_PutThing();
char *		dm_GetThing();	/* cast to appropriate type */
int		dm_FreeThing();

long		dm_PutExpr();
EXPR_PTR	dm_GetExpr();
int		dm_FreeExpr();

long		dm_PutFcall();
FCALL_PTR	dm_GetFcall();
int		dm_FreeFcall();

long		dm_PutCodeList();
CODE_PTR	dm_GetCodeList();
int		dm_FreeCodeList();

long		dm_PutObjList();
OBJ_PTR		dm_GetObjList();
int		dm_FreeObjList();

long		CreateObjDict();
int		DestroyObjDict();
HashTablePtr	CreateObjHT();

long		dm_PutEnvList();
ENV_PTR		dm_GetEnvList();
int		dm_FreeEnvList();

#endif
