
#include <stdio.h>
#include "m1.h"
#include "lookups.c"
#include "gets.c"

char *calloc();
char *malloc();
DisplayPtr readfile();
DisplayPtr dsp1, dsp, tdsp;	   
ElementPtr ele, tele;
ScreenPtr scr, tscr;
DimensionPtr dim;
MapPtr map, tmap;

int linecount = 0;

DisplayPtr
readfile( datafile )

	char *	datafile;
{
static char *funcname = "Readfile";
FILE *fp;
int found,success;
char line[MAXSTR], word[MAXSTR];
int num;
int i, n = 0;
int dimcount = 0;

	found = success = 0;

	if( (fp = fopen( datafile, "r" )) == NULL ) {
		printf("%s: Can't open file %s\n",datafile);
		return (NULL);
		}
printf("Opened %s\n",datafile);

	while( !feof(fp)) {
	  if(n == 0){
	    ++linecount;
	    fgets( line, MAXSTR, fp );
	    line[strlen(line) - 1] = NULL;
	    if( line[0] == '#' || line[0] == ' ' || line[0] == '\t' 
	       || !strlen(line) ){ 
		 continue;
	       }
	        if( (n = lookup(line)) == NULL) 
		  printf("Lookup: No match for %s, line %d\n",line,linecount);
	  }

		  switch (n){
		  case DISPLAY:
		    if(Supressed(MSK_DISPLAY)) 
		      signal_unexpected("display",funcname,linecount);
		    if(dsp && scr && dsp->screen->name[0] == 0) 
		      {
			dsp->screen = NULL;
		      }
		    if((tdsp = (DisplayPtr) calloc(1,sizeof(Display)))==NULL){
		      printf("%s: Can't allocate display\n",funcname);
		      return (NULL);
		    }
		    Supress(MSK_DISPLAY); /* block until some elements are in*/
		    if(dsp) dsp->cnext = tdsp;
	            tdsp->cprev = dsp;    /* link it in the chain */
		    dsp = tdsp;
		    if(!dsp1) dsp1 = dsp;


		    if((ele = (ElementPtr) calloc(1,sizeof(Dsp_ele))) == NULL){
		      printf("%s: Can't allocate element\n",funcname);
		      return (NULL);
		    }
		    Supress(MSK_ELEMENT);
		    tdsp->ele = ele;

		    if((map=(MapPtr) calloc(1, sizeof(Map)))==NULL){
 		      printf("%s: Can't allocate map\n",funcname);
		      return (NULL);
		    }
		    Supress(MSK_MAP);
		    ele->map = map;



		    if((scr=(ScreenPtr) calloc(1, sizeof(Screen_ele)))==NULL){
 		      printf("%s: Can't allocate screen\n",funcname);
		      return (NULL);
		    }
		    Supress(MSK_SCREEN);
		    tdsp->screen = scr;

		    if((dim = (DimensionPtr) calloc(1, sizeof(Dimension)))
		       ==NULL){
 		      printf("%s: Can't allocate dimension\n",funcname);
		      return (NULL);
		    }
		    Supress(MSK_DIMENSION);
		    tdsp->dims[0] = dim;

 
		    n = getdisplay(fp, tdsp); /* fill in the slots */
		    break;

		  case DSP_ELEMENT:
		    if(Supressed(MSK_ELEMENT)){
		      tele = ele;
		      Unsupress(MSK_ELEMENT);
		      }
		    else{
		      if((tele =(ElementPtr) calloc(1,sizeof(Dsp_ele)))==NULL){
			printf("%s: Can't allocate element\n",funcname);
			return (NULL);
		      }
		      if(ele) ele->cnext = tele;
		      tele->cprev = ele;
		      ele = tele;
		    }
		    n = getelement(fp, tele); /* fill in the slots */

		    Unsupress(MSK_DISPLAY);		    
		    break;


		  case SCR_ELEMENT:
		    if(Supressed(MSK_SCREEN))
		      {
			tscr = scr;
			Unsupress(MSK_SCREEN);
		      }
		    else{
		     if((tscr =(ScreenPtr)calloc(1,sizeof(Screen_ele)))==NULL){
			printf("%s: Can't allocate screen\n",funcname);
			return (NULL);
		      }
		      if(scr) scr->cnext = tscr;
		      tscr->cprev = scr;
		      scr = tscr;
		    }
		    n = getscreen(fp, tscr); /* fill in the slots */
		    break;



		  case MAP:
		    if(Supressed(MSK_MAP))
		      {
			tmap = map;
			Unsupress(MSK_MAP);
		      }
		    else{
		     if((tmap =(MapPtr)calloc(1,sizeof(Map)))==NULL){
			printf("%s: Can't allocate map\n",funcname);
			return (NULL);
		      }
		      if(map) map->cnext = tmap;
		      tmap->cprev = map;
		      map = tmap;
		    }
		    n = getmap(fp, tmap); /* fill in the slots */
		    break;



		  case DIMENSION:
		    if(Supressed(MSK_DIMENSION))
		      {
			Unsupress(MSK_DIMENSION);
		      }
		    else{
		     if(++dimcount > MAXDIMS ||
			(dim =(DimensionPtr)calloc(1,sizeof(Dimension)))
			==NULL){
			  printf("%s: Can't allocate dimension\n",funcname);
			  return (NULL);
			}
		     dsp->dims[dimcount] = dim;
		    }
		    n = getdimension(fp, dim); /* fill in the slots */
		    break;



		  case INCLUDE:
		    if( fscanf(fp,"file: %s\n",line) != 1 )
		      printf("Include file missing at line %d\n",linecount);
		    readfile(line);
		    break;

		  default:
		    printf("%s: Parse error at line %d in %s\n"
			   ,funcname,linecount,datafile);
		    break;
		  }
	
	      }
return (dsp);
}



DisplayPtr
write_displays( datafile )

	char *	datafile;
{
static char *funcname = "Write_displays";
FILE *fp;
char line[MAXSTR];
int num, linecount = 0;
int i = 0;
int n;


if( (fp = fopen( datafile, "w" )) == NULL ) {
  printf("%s: Can't open file %s\n",datafile);
  return (NULL);
}
tdsp = dsp1;
while(tdsp != NULL){
  fprintf(fp,"\ndisplay\n");
  fprintf(fp,"name: %s\n",tdsp->name);
  if(tdsp->init_active == YES) fprintf(fp,"active\n");
  fprintf(fp,"next: %s\n",tdsp->nextname);
 
  for(i=0;(dim = tdsp->dims[i]);++i){
    fprintf(fp,"\ndimension\nname: %s\nmax: %d\nmin: %d\nboundary %d\n"
	    ,dim->name,dim->max,dim->min,dim->boundary);
  }

  tele = tdsp->ele;
  while(tele != NULL){
  fprintf(fp,"\nelement\nname: %s\ntype: %d\n",tele->name,tele->type);
  if(tele->init_active == YES) fprintf(fp,"active\n");
  if(tele->nextname != NULL) fprintf(fp,"next: %s\n",tele->nextname);
  if(*tele->file != '\0') fprintf(fp,"filename: <%s>\n",tele->file);
  else{
    tmap = tele->map;
    fprintf(fp,"\nmap\nin: %d\nout %d\nicon %d\nlabel %s\n"
	    ,tmap->in,tmap->out,tmap->icon,tmap->text);
  }
  tele = tele->cnext;
}

  tscr = tdsp->screen;
  while(tscr != NULL){
  fprintf(fp,"screen\n");
  tscr = tscr->cnext;
  }

tdsp = tdsp->cnext;
}

fclose(datafile);

}



main(argc,argv)

	int argc;
	char **argv;
{
char fn[64];
char nbuf[12];
int num;
DisplayPtr vmp;

	if( argc > 1 ) strcpy(fn,argv[1]);
	else {
		printf("what data file ? ");
		gets( fn );
		}

	vmp = readfile( fn );

	if( vmp == NULL ) exit(1);
	printf("TEST: \n");

        vmp = write_displays("test.dat");
}
