/* 
 * sub2.c - subtitling display for Foreign Language courses
 * Matt Hodges, June, 1987
 *
 * Make executable with:
 *	cc -o sub2.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>

#define PLX 1

#define FAILURE 0
#define VIDBACK 0
#define SETTLE count(5000)

#define STOPPED 0
#define PAUSE 1
#define PLAYING 2

#define TIMELIMIT 60
#define TIMECTRL_WIDTH  630 /* pixels in the time control bar */
#define YES 1
#define NO 0
#define MAXMARKS 50

#define OFF 0
#define TEXT_TYPE 1
#define VIDEO_TYPE 2
#define DISP_TYPE 3
#define LINE 1
#define LOOP 2
#define MAXDIMS 5

#define MAKE16(z) (z)=((z)+8)&(~0xf)

#define addbutton(w)\
    buttons[buttoncount].name = XtAWindow;\
    buttons[buttoncount].value = (caddr_t)w;\
    buttoncount++;

#define BORDERWIDTH 1


/***************
*  Windows needed
*/
Window background; /* covers screen */
Window windowid;  /* main display window */
Window   sw, rate_scr;  /*scroll windows */
Window timewindow;  /* time display */
Window butbox;  /* button box window */
Window fwd, rev, stp, mrk;  /* command button windows */
Window dw; /* filename dialog */
Window subtitles; 


/********************
* video window stuff 
*/

#define FAILURE 0
#define VIDBACK 0
Window VideoWindow;
Window v1,v2;
OpaqueFrame	frame;
int disc = -1;
int sframe = 2001;



/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;



/***************
*  General global vars.
*/
XEvent rp, *rep = &rp; /* global event */
Font f, tf;
int len;
char cmd[32];
char *msg[30];
int time;
int timeinc = 1;
int time_is_on = NO;
int count_marks;
int mark[MAXMARKS];
int rate;
int timer();
int tries = 0;

FILE *fp;


/**************
* Functions
*/
char *calloc();
void show();
void update_display();


/***************
*  Timer structs
*/
struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


/************* 
*  Map struct 
*/
struct map{    struct map *next;
	       struct map *prev;
	       int time; /* to be replaced w/ posn spec on n dims */
	       long in;
	       long out;
	       long icon;
	     };
 
struct map txta, *text = &txta;
struct map vdeo, *video = &vdeo;

/******************
*  Dimension struct
*/
struct dimsum {
  float min;  /* minimum value on this dim */
  float max;
  float current; /* current pos'n on this dim */
  float range;  /* what extent is being displayed, rel. to current */
  int topology; /* LINE,LOOP,BOUNCE */
 };
	       
/********************
*  Display elements
*/
typedef struct _Dsp_ele{
  int on;  /* on the screen or not */
  int type;    /* text, video, etc. */
  int state;   /* video playing or not */
  int geom;    /* code for geometry of the data */
  struct map *map;  /* head of item list */
  struct map *now_showing;
  int current_frame;
  struct _Dsp_ele *next;
  struct _Dsp_ele *prev;
  Window w;
} Dsp_ele;


/*********************
*  Display
*/
typedef struct _Display{
  Dsp_ele *ele;  /* list of display elements */
  int duration; /* how many clock ticks at 1/30th sec */
  int ndims;
  struct dimsum dims[MAXDIMS];
} Disp;


/**************
*  Test parts 
*/
Dsp_ele vdpart = {OFF,VIDEO_TYPE,STOPPED,LOOP};
Dsp_ele *vidpart = &vdpart;
Dsp_ele txpart = {OFF,TEXT_TYPE,STOPPED,LOOP};
Dsp_ele *txtpart = &txpart;
Disp dsplay, *display = &dsplay;



/***************************************************
*   Filename Dialog stuff 
*/
DialogButton dbuttons;
static char bname[] = "OK";

DialogValue dvalue;

static char label[] = "Enter filename:";

static char instring[80];

static Arg dialogArgs[] = {
    {XtADialogValue, (caddr_t) &dvalue},
    {XtADialogButtons, (caddr_t) &dbuttons},
    {NULL, NULL}	/* needed to terminate argument list */
};

/****************
*  Dialog button 
*/
static int FilenameAction()
{
    char s[256];
    int n = 0;
    struct map *tmp;
    int lastout = 0;
    int unit;

    printf("Filename: %s\n",dvalue.string);

    if((fp = fopen(dvalue.string, "r")) == NULL){
      printf("Problem opening %s\n",dvalue.string);
      exit(1);
    }


    text->next = 0;
    text->prev = 0;
    text->time = n++;
    text->in = ftell(fp);
    if(fgets(s,256,fp) == NULL){
      printf("Failed on first string\n");
      exit(1);
    }
    text->out = ftell(fp);
    lastout = text->out;
    
    while ( fgets(s,256,fp) != NULL){ /* End of file or error */
      tmp = (struct map *) calloc(1, sizeof(struct map));
      tmp->time = ++n;
      tmp->in = lastout;
      tmp->out = ftell(fp);
      lastout = tmp->out;
      text->prev = tmp;
      tmp->next = text;
      text = tmp;

    }

    unit = (TIMELIMIT/n);

    tmp = text;
    while(tmp != 0){
      tmp->time = tmp->time * unit;
      tmp = tmp->next;
    }

    txtpart->map = text;

    printf("Mapped %d items from %s\n",n,dvalue.string);

    XUnmapWindow(dw);

    

}







/***************************************************
*  Control button procedures  (Fwd, Rev, Stop, Mark)
*/
static void Forward()
{
if(! time_is_on){  
  time_is_on = YES; 
 }

timeinc = 1;
}

/*****************
*  Reverse
*/
static void Reverse()
{
if(! time_is_on){
  time_is_on = YES;
	  sprintf(cmd,"rplay");
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE; 
#else
	  printf("Video call: %s\n",cmd);
#endif

 }

timeinc = -1;
}



/*****************
*  Stop
*/
static void Stop()
{
time_is_on = NO;
	  sprintf(cmd,"still");
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE; 
#else
	  printf("Video call: %s\n",cmd);
#endif

}



/******************
*   Mark
*/
static void Mark()
{
/*if(++count_marks < MAXMARKS){
  mark[count_marks] = time;


 }
else printf("Marks array is full.\n");
*/
#if PLX
sony_close( disc );
#else
	  printf("Video call: sony_close\n");
#endif

exit(0);
}




/***********************
*  Command button labels
*/
static char mrk_label[] = "Quit";
static char fwd_label[] = "Forward";
static char rev_label[] = "Reverse";
static char stp_label[] = "Stop";




static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) fwd_label},
    {XtAFunction, (caddr_t) Forward},
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}	/* needed to terminate argument list */
};

static Arg bbarglist[] = {
    {XtABorderWidth, (caddr_t) BORDERWIDTH},
    {NULL, NULL}
};








/***********************************************************************
*  Scroll Window routines (time slide, time thmb, rate slide, rate thmb)
* 
*   Time bar -- buttons 1 and 3  routine
*/
static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}



/****************
*  Time bar thumb (middle button)
*/
static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{

  time = (tp/100)*TIMELIMIT;
  sprintf(msg,"Time %d   ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
  
}



/*********************
*  Rate bar thumb routine
*/
static void RateThmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{
  tp = tp - 50;
  if (tp<0){
    timeinc = -1;
    rate = 51 + tp;
  }
  else{
    timeinc = 1;
    rate = 51 - tp;
  }
printf("%d\n",rate);
}  



/**************************
*  Scroll bar argument list
*/

static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 630},
  {XtAHeight, (caddr_t) 20},
  {XtABorderWidth, (caddr_t) BORDERWIDTH},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};









/********************************************************
*  MAIN
*/

void main()
{
    Disp *d;


int count = 0;
int len;
char *msg[30];
Arg buttons[4];
int buttoncount;
int framecount;
float x, ft;
Dsp_ele *tmp;


/**************************
*  Set up the root window
*/
if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }

if(tries == 1){

/***********************
*  Start video
*/
#if PLX
  disc = sony_open( 4800, getenv("DISCPORT") );
#else
	  printf("Video call: sony_open\n");
#endif

/*
  background = XCreateWindow(RootWindow,
			 0,
			 0,
			 DisplayWidth(),
			 DisplayHeight(),
			 3,
			 BlackPixmap,
			 BlackPixmap);
*/

  windowid = XCreateWindow(RootWindow,
			 (1280-700)/2,	 /* centered */
			 100,
			 700,
			 700,
			 3,
			 BlackPixmap,
			 WhitePixmap);

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }
  if((tf = XGetFont("sbdr40ssx")) == 0)
    {  printf("Failed XGetFont sbdr40ssx\n");
       exit(1);
     }


  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }


  XSelectInput(windowid, ButtonPressed 
	               | ButtonReleased 
	               | KeyPressed
	               | MouseMoved
	               | EnterWindow
	               | LeaveWindow);



/*******************************
*  Set up the subtitles window
*/
  subtitles =XCreateWindow(windowid,
			 25,  /* x */
			 645, /* y */
			 650, /* width */
			 50,  /* height */
			 3,   /* border width */
			 BlackPixmap,
			 WhitePixmap);




    XtInitToolkit();

/****************************
*  Display the command buttons
*/
    butbox = XtCreateButtonBox(windowid,bbarglist);

    buttonArgs[0].value = (caddr_t) fwd_label;
    buttonArgs[1].value = (caddr_t) Forward;
    fwd = XtCreateCommand(butbox, buttonArgs);
    addbutton(fwd);

    buttonArgs[0].value = (caddr_t) stp_label;
    buttonArgs[1].value = (caddr_t) Stop;
    stp = XtCreateCommand(butbox, buttonArgs);
    addbutton(stp);

    buttonArgs[0].value = (caddr_t) rev_label;
    buttonArgs[1].value = (caddr_t) Reverse;
    rev = XtCreateCommand(butbox, buttonArgs);
    addbutton(rev);

    buttonArgs[0].value = (caddr_t) mrk_label;
    buttonArgs[1].value = (caddr_t) Mark;
    mrk = XtCreateCommand(butbox, buttonArgs);
    addbutton(mrk);

    (void)XtButtonBoxAddButton(butbox,buttons);

    XMoveWindow(butbox, 5,585);


/********************************
*  Put up the time scroll bar
*/
    sw = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(sw, 5, 560);

/*******************************
*  Put up the rate scroll bar
*/
    scrargs[1].value = (caddr_t)200;
    scrargs[5].value = (caddr_t)RateThmb;
    rate_scr = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(rate_scr, 300, 585);

    XLine(rate_scr, 100,10,100,25,1,1,BlackPixel,GXcopy,AllPlanes);

/*******************************
*  Put up the filename dialog
*/
    dbuttons.name = bname;
    dbuttons.funct = FilenameAction;
    dbuttons.param = NULL;

    dvalue.tag = label;
    dvalue.string = instring;
    dvalue.length = 80;

    dw = XtCreateDialog(RootWindow, dialogArgs);

    XMoveWindow(dw, 10, 10);


/*******************************
*  Video Window
*/
#if PLX
	frame.bdrwidth = 0;   /* was 16 */
	frame.border = XMakeTile(BlackPixel);
	frame.background = XMakeTile(VIDBACK);

	v1 = XCreateVideo (
	"Video Window",
		"video",
		"640x480+320+110",
		"640x480+320+110",
		&frame,
		48,
		50);
	if (v1 == FAILURE) {
		printf("Can't open video window\n");
		exit(1);
	}

#else
	  printf("Creating video window\n");
#endif

  XMapWindow(windowid);
  XMapWindow(subtitles);
    XMapWindow(fwd);
    XMapWindow(stp);
    XMapWindow(rev);
    XMapWindow(mrk);
    XMapWindow(butbox);
    XMapWindow(sw);
    XMapWindow(dw);
    XMapWindow(rate_scr);
#if PLX
    XMapWindow(v1);
#endif



display->ele = vidpart;
display->duration = 300; 

vidpart->next = txtpart;
vidpart->w = v1;
vidpart->map = video;
vidpart->current_frame = 0;
vidpart->type = VIDEO_TYPE;
vidpart->state = STOPPED;

video->time = 0;
video->in = 17415;
video->out = 18324;


txtpart->prev = vidpart;
txtpart->w = subtitles;
txtpart->type = TEXT_TYPE;
/*******************************
*  Start up the clock
*/  
  timvl.it_value.tv_sec = 0;
  timvl.it_value.tv_usec = 33333; /* 30th of a second clock res. */
  timvl.it_interval.tv_sec = 0;
  timvl.it_interval.tv_usec = 33333;

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();
}





/*******************************
*  Start the main control loop
*/

    for(;;) {

	XNextEvent(&event);		  /* Get next event */
	(void) XtDispatchXEvent(&event);  /* Hand it to Toolkit Dispatcher */


       if(event.rep.window == sw){  /* scroll window */
        switch (event.rep.type){
	  case  ButtonPressed:
	        time_is_on = NO;
		tmp = display->ele;
		while(tmp != 0){
		  if(tmp->type == VIDEO_TYPE && tmp->state == PLAYING){
		    	sprintf(cmd,"still");
#if PLX
			sony_cmd( disc, cmd );
#else
			printf("Video call: %s\n",cmd);
#endif
			tmp->state = PAUSE;
			framecount = tmp->map->out - tmp->map->in;
			tmp->current_frame = 
			     (((ft = time)/framecount) * framecount) 
				+ tmp->map->in;  
		  }
		  tmp = tmp->next;
		}
		  x = event.buttpress.x;
		  time = ((x) / 630)*TIMELIMIT;
		  sprintf(msg,"Time %d   ",time);
		  len = strlen(msg);

		  XText(windowid,
		      540,510,msg,len,f,BlackPixel,WhitePixel);
		  XFlush();
		break;

	  case  ButtonReleased:
		time_is_on = YES;
		tmp = display->ele;
		while(tmp != 0){
		  if(tmp->type == VIDEO_TYPE && tmp->state == PAUSE){
		    	sprintf(cmd,"fplay");
#if PLX
			sony_cmd( disc, cmd );
			tmp->state = PLAYING;
			XStartVideo(v1,0,0,2);
#else
			printf("Video call: %s\n",cmd);
#endif
		  }
		  tmp = tmp->next;
		}
		break;
	  case  MouseMoved:
		if(! time_is_on){ /* means adjustment under way*/
		  x = event.mousemove.x;
		  time = ((x) / TIMECTRL_WIDTH) * display->duration;
		  sprintf(msg,"Time %d   ",time);
		  len = strlen(msg);
		  XText(windowid,
		      540,510,msg,len,f,BlackPixel,WhitePixel);
		  XFlush();

		  update_display(time,display);

		}
		break;

		
		


	      }
      }
      }
  }
/******************  END MAIN */




/**********************************************************************
*  Timer interrupt routine
*/
int 
timer()
{

  char *msg[30];
  int len;
  float tp,sp;
  float fti;
  static int count;

if(time_is_on){  /* if time is off, don't do anything */
 if(++count > rate){
  count = 0;

  time = time + timeinc;

  if(time < 0) time = display->duration;
  if(time > display->duration) time = 0;



  sprintf(msg,"Time %d  ",time);
  len = strlen(msg);

  XText(windowid,
	540,510,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

  tp = ((fti=time)/TIMELIMIT)*100;
  sp = 0; 
  XtSetScrollBarPercentages(sw,tp,sp);

  update_display(time,display);
 }
}

}



/*******************************************************************
*  Update Display
*/
void
update_display(time,dsp)
  int time;
  Disp *dsp;
 {
  Dsp_ele *ele;
  struct map *tmp; /* = ele->map;*/  /* map of display fragments */
  int frm, framecount;
  float ft;

  ele = dsp->ele;
  tmp = dsp->ele->map;



  while(ele != 0){

    switch (ele->type){
    case TEXT_TYPE:

      while((tmp->next != 0) && (tmp->time > time)){
	tmp = tmp->next;
      }

      if(tmp != ele->now_showing && tmp->time <= time){
	show(tmp,ele->w);
        ele->now_showing = tmp;
      }
      break;


    case VIDEO_TYPE:

      if(ele->state != PLAYING){  /* let play sequences go */

	framecount = ele->map->out - ele->map->in;
	frm = (((ft = time)/framecount) * framecount) + ele->map->in;
	if(frm != ele->current_frame){
	  ele->current_frame = frm;
	  sprintf(cmd,"search %d",frm);
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE; SETTLE; SETTLE; SETTLE; SETTLE;
	  XStillVideo(v1,0,0,0,0,640,482);
	  XFlush();

	  SETTLE; SETTLE;
#else
	  printf("Video call: %s\n",cmd);	  
#endif

	}
      

	if(time_is_on && ele->map->time < time){ /* then get the video going */
	  sprintf(cmd,"fplay");
#if PLX
	  sony_cmd( disc, cmd );
	  SETTLE; SETTLE;
	  XStartVideo(v1,0,0,2);
	  XFlush();
#else
	  printf("Video call: %s\n",cmd);
#endif
 	  ele->state = PLAYING;
	}
      }      

      break;

    case DISP_TYPE:

      break;

    }
  ele = ele->next;
  tmp = ele->map;
  }
}


/*******************************************************************
*  Show text fragment
*/
void
show(tmp,w)
  struct map *tmp;
  Window w;
{
  char msg[256];


  if( fseek(fp,tmp->in,0) ) printf("FSEEK err to %d\n",tmp->in);
  if( fgets(msg, 255, fp) == NULL ) printf("NULL fgets\n");;
  len = strlen(msg);
  XClear(w);
  XText(w,
	5,5,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

}


count(n)
	int n;
{
int i;
for( i=0; i<n; i++ );
}
