/*
helper is supposed to be linked to commands that you want k deactivated
when they run.  helper signals k to "turn off" and executes your command
as a subprocess.  This ensures that file descriptor 0 is a tty.
I link helper to vi, ed, and emacs.

helper reads k's PID from the environment variable KPID and signals
k with SIGUSER2 to "turn off."  After k is off, k reads helper's
PIC from /tmp/KPID and signals helper to continue with SIGUSER2.
helper then execs your command and when finished signals k to "turn
on" with SIGUSER1.

*/

#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#define MAXFD 19


extern char *getenv(), *malloc();
static int trap();
int done;

char *cmdname, *pathname;
char pidkill[500];
int pid, kpid;

main(argc, argv)
int argc;
char *argv[];
{
	int i;
	char *ptr;

	if (!(cmdname = strrchr((pathname = argv[0]), '/'))) cmdname = pathname;

/*	get the process id for k */

	if (!(kpid = (ptr=getenv("KPID"))? atoi(ptr): 0)) {
		myexecvp(cmdname, argv);
		fprintf(stderr, "%s not found\n", cmdname);
		exit(-1);
	}

	{
	int fd;
	int x;
	char name[512];
		x = getpid();
		strcpy(name, "/tmp/");
		strcat(name, ptr);
		if ((fd = open(name, O_WRONLY|O_TRUNC|O_CREAT, 0700)) < 0) {
			fprintf(stderr,"can\'t open /tmp\n");
			exit (-1);
		}
		if (write(fd, &x, sizeof(int)) != sizeof(int)) {
			fprintf(stderr,"can\'t write /tmp\n");
			exit (-1);
		}
		close (fd);
	}

	for (i=0; i<MAXFD; i++)
		if (isatty(i))
			break;

	if ((i > 0) && (i < MAXFD)) {
		close(0);
		dup(i);
	} else if (i != 0) {
		fprintf(stderr,"no tty\n");
		exit(-1);
	}


	signal (SIGUSR2, trap);
	signal (SIGUSR1, trap);
	signal (SIGALRM, trap);

	kill (kpid, SIGUSR2); /* tell k to turn off */

	/* wait for k to turn off; call alarms in case anything goes wrong */
	alarm(2);	/* just in case */
	while (!done) {
#ifdef Berkeley
		sigpause (0);
#else
		pause ();
#endif
	}
	alarm(0);	/* just in case */


	pid = fork();

	if (pid < 0) {
		fprintf(stderr, "%s: could not fork\n", cmdname);
		exit (-1);
	}

/*
	child process strategy:
	take the code for execvp() and skip a directory in the path environment
        variable.  to keep from infinite recursion, pass the complete pathname
        in argv(0) and compare to complete path prior to exec.  if equal, exit
        instead of exec-ing.  then at most two of these guys will run.
 */
	if (pid == 0) {
		signal (SIGUSR2, SIG_IGN);
		myexecvp(cmdname, argv);
		fprintf(stderr, "%s not found\n", cmdname); fflush(stderr);
		exit(-1);
	}

/*
	parent process strategy:
	ignore some signals, then ...

 */

	signal (SIGQUIT, SIG_IGN);
	signal (SIGHUP, SIG_IGN);
	signal (SIGINT, SIG_IGN);

	while (wait(0) != pid)
		;

	kill (kpid, SIGUSR1); /* turn k back on */

	exit(0);
}




#include <sys/errno.h>
#define	NULL	0

static char *execat(), shell[] = "/bin/sh";
extern unsigned sleep();
extern int errno, execv();


int
myexecvp(name, argv)
char	*name, **argv;
{
	char	*pathstr;
	char	fname[128];
	char	*newargs[256];
	int	i;
	register char	*cp;
	register unsigned etxtbsy=1;
	register int eacces=0;
	char *oldcmdname, *npstr;

	if((pathstr = getenv("PATH")) == NULL)
		pathstr = "/bin:/usr/bin";	/*RnD-PATH*/

/* Skip first entry in path variable because this entry should point the
directory containing helper and k.  Otherwise there might be an infinite
recursion. */
	while(*pathstr && *pathstr++ != ':')
		;
	npstr = malloc(strlen(pathstr)+7);
	strcpy(npstr,"PATH=");
	strcat(npstr, pathstr);
	putenv(npstr);

	cp = pathstr;

	oldcmdname = *argv;

	retry:
		(void) execvp(name, argv);
		switch(errno) {
		case ENOEXEC:
			newargs[0] = "sh";
			newargs[1] = name;
			for(i=1; newargs[i+1]=argv[i]; ++i) {
				if(i >= 254) {
					errno = E2BIG;
					return(-1);
				}
			}
			(void) execv(shell, newargs);
			return(-1);
		case ETXTBSY:
			if(++etxtbsy > 5)
				return(-1);
			(void) sleep(etxtbsy);
			goto retry;
		case EACCES:
			++eacces;
			break;
		case ENOMEM:
		case E2BIG:
			return(-1);
		}
	if(eacces) {
		errno = EACCES;
	}
	return(-1);
}


static char *
execat(s1, s2, si)
register char *s1, *s2;
char	*si;
{
	register char	*s;
	int i;

	s = si;

	while(*s1 && *s1 != ':')
		*s++ = *s1++;
	if(si != s)
		*s++ = '/';
	while(*s2)
		*s++ = *s2++;
	*s = '\0';
	return(*s1? ++s1: 0);
}


static int
trap(sig)
int sig;
{
	signal (sig, trap);
	done = (sig == SIGUSR2);
}
