#define LAST_EVENT_TAG 100
#define CORNER_TAG 101
#define MENU_TAG 102
#define XY_INPUT_TAG 103

% 
% Define the server-resident routines and initialize the graphics
% window.
% 


cdef ps_initialize()

    /Pch 1 string def			% the plotting character
    /Xoffset 0 def			% the plotting offset
    /Yoffset 0 def
    /Cex 1 def				% the character expansion
    /Text-y 0 def			% Y-offset for text strings
    /StringRot 0 def			% angle (in degrees)
    /LineTypes [			% in default units
	[]		[1 2]		[4 4]		[8 4]
	[13 3]		[16 2 2 2]	[8 2 2 2]	[1 13]
	[6 5]		[12 4]
    ] def

    /Rem {				% remainder,  x y => (x)mod(y)
	2 copy div floor mul sub floor cvi
    } def

    /SetPlotChar {			% pch => -
	Pch exch 0 exch put
	gsave
	newpath 0 0 moveto Pch false charpath flattenpath pathbbox
	exch 3 1 roll
	add 2 div neg /Yoffset exch def
	add 2 div neg /Xoffset exch def
	grestore
    } def

    /SetLineType {			% lty => -
	1 sub				% lty-1
	LineTypes dup 3 1 roll		% LineTypes lty-1 Linetypes
	length Rem floor		% LineTypes (lty-1)mod
	get 0 setdash			% -
    } def

    /SetLineWidth {			% lw => -
	abs 2 div setlinewidth
    } def

    /SetCex {				% cex => -
	dup Cex div /Ratio exch def
	/Cex exch store
	currentfont Ratio scalefont setfont
	/Xoffset Xoffset Ratio mul store
	/Yoffset Yoffset Ratio mul store
	gsave newpath 0 0 moveto
	(M) false charpath
	flattenpath pathbbox		% 0 0 urx ury
	2 div neg /Text-y exch def pop pop pop
	grestore
    } def

    /SetSrt {				% set string rotation, srt => -
	/StringRot exch store
    } def

    /SetGray {                               % set gray level for area fills, col => -
       /Gray exch 11 mod 0.1 mul 1 exch sub store
     } def

    /WriteXY {				% dumpout the x-y coordinates of the mouse
	XY_INPUT_TAG tagprint
	begin
	    can setcanvas
	    currentcursorlocation exch
	    typedprint
	    typedprint
	end
    } def

    /Ib {				% setup input
	/xhair /xhair_m can setstandardcursor
	/MouseEventMgr [
	    PointButton {
		WriteXY
		1 typedprint
	    } /DownTransition can eventmgrinterest
	    AdjustButton {
		WriteXY
		2 typedprint
	    } /DownTransition can eventmgrinterest
	    MenuButton {
		WriteXY
		3 typedprint
	    } /DownTransition can eventmgrinterest
	] forkeventmgr def
    } def

    /Ie {				% end input
	MouseEventMgr killprocess
	/ptr /ptr_m can setstandardcursor
    } def

    /SendDimensions {
	can setcanvas clippath pathbbox
	CORNER_TAG tagprint
	2 sub typedprint
	2 sub typedprint
	2 add typedprint
	2 add typedprint
    } def
    
    /Cl {
	can setcanvas
	gsave
	1 fillcanvas
	grestore
    } def

    /PM {				% x y => -
	moveto
	Xoffset Yoffset rmoveto		% so that mark is centered
	Pch show
    } def

    /ST {				% pos str x y => -
	moveto
	dup stringwidth pop		% pos str wx
	3 -1 roll			% str wx pos
	mul neg Text-y rmoveto show	% presently no string rotation.  This is
    } def				% broken in NeWS 1.0

    /MenuReset {
        win /ClientMenu [ (null) {} ] /new DefaultMenu send put
    } def

    /AddMenuItem {			% str => -
	1 exch {
            /currentindex self send
            MENU_TAG tagprint
            typedprint
        } /insertitem win /ClientMenu get send
    } def

    /ModifyMenuNull {
	0 (null) {
            /currentindex self send
            MENU_TAG tagprint
            typedprint
        } /changeitem win /ClientMenu get send
    } def

    /win framebuffer /new DefaultWindow send def % graphics window
    {
	/PaintClient {
	    SendDimensions		% and replay plot
	} def
	/FrameLabel (S graphics) def
	/IconImage /davinci def
	/ClientMenu [ (null) {} ] /new DefaultMenu send def
	reshapefromuser	map
	/Times-Roman findfont 10 scalefont setfont
    }  win send
    /can win /ClientCanvas get def	% graphics canvas
    SendDimensions

%
% Entry points for the device driver.
% 

cdef ps_clear()
    Cl
cdef ps_plot_mark(x,y)
    x y PM
cdef ps_show_text(string str,x,y,float pos)
    pos str x y ST
cdef ps_fill_path()
   gsave Gray setgray fill grestore
cdef ps_menu_reset()
    MenuReset
cdef ps_add_menu_item(string str)
    str AddMenuItem
cdef ps_modify_menu_null()
    ModifyMenuNull
cdef ps_send_me_tag(seq)
    LAST_EVENT_TAG tagprint
cdef ps_input_setup()
    Ib
cdef ps_input_shutdown()
    Ie
cdef ps_get_dimensions(float x0, float y0, float x1, float y1 )
    => CORNER_TAG(y1,x1,y0,x0)
cdef ps_menu_hit(int index) => MENU_TAG(index)
cdef ps_last_event() => LAST_EVENT_TAG()
cdef ps_xy_input(int x, int y, int button) => XY_INPUT_TAG(x, y, button)

% 
% Routines for setting parameters.
% 

cdef ps_set_plot_char(pch)		% the plot character
    pch SetPlotChar
cdef ps_set_line_type(lty)		% the line type
    lty SetLineType
cdef ps_set_line_width(float lw)	% the line width
    lw SetLineWidth
cdef ps_set_cex(float cex)		% the character expansion
    cex SetCex
cdef ps_set_srt(float srt)		% the string rotation
    srt SetSrt
cdef ps_set_gray(col)			% the gray level for area fill
	col SetGray
