/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#include <sys/types.h>

/*
 * bcopy -- vax movc3 instruction
 *
 * tuned for the register allocation algorithm on the convex
 */
bcopy(src, dst, length)
	char *src;
	char *dst;
	register int length;
{
	if (length && src != dst)
		if ((u_int)dst < (u_int)src)
			if (((int)src | (int)dst | length) & 3) {
				register char *d = dst;
				register char *s = src;
				do	/* copy by bytes */
					*d++ = *s++;
				while (--length);
			} else {
				register long *d = (long *)dst;
				register long *s = (long *)src;
				length >>= 2;
				do	/* copy by longs */
					*d++ = *s++;
				while (--length);
			}
		else {			/* copy backwards */
			src += length;
			dst += length;
			if (((int)src | (int)dst | length) & 3) {
				register char *d = dst;
				register char *s = src;
				do	/* copy by bytes */
					*--d = *--s;
				while (--length);
			} else {
				register long *d = (long *)dst;
				register long *s = (long *)src;
				length >>= 2;
				do	/* copy by longs */
					*--d = *--s;
				while (--length);
			}
		}
	return(0);
}
