#define NOARG 1073741827

/* defines for NA */
#define NA_PATTERN 2146435072L
#define is_na(a) natst_(a)
#define na_set(a) *((long *)(a)) = NA_PATTERN

/* the mapping from f77 to C intermediate code -- may be machine dependent
 * the first definition satisfies lint's narrowminded preprocessing & should
 * stay the same for all implementations.  The __STDC__ definition is for
 * ANSI standard conforming C compilers. The #else definition should
 * generate the version of the fortran subroutine & common block names x
 * handed to the local loader; e.g., "x_" in system V, Berkeley & 9th edition
 */
#ifdef lint
#define F77_SUB(x) x
#define F77_COM(x) x
#else
#ifdef __STDC__
#define F77_SUB(x) x##_
#define F77_COM(x) x##_
#else
#define F77_SUB(x) x/**/_
#define F77_COM(x) x/**/_
#endif
#endif
/* Defines to handle generation of internal names for C and Fortran
 * on many machines, these symbols are have a leading underscore
 * but on some, particularly System V, they do not
 */
#define SYMBOL(x)	QUOTE(x)
#define FSYMBOL(x)	QUOTE(x/**/_)
#define QUOTE(x)	"x"

/* Typedef and define to handle conversion of character variables between
 * Fortran and C
 */

typedef char *F_CHARTYPE;	/* how C sees F77 character variables */
#define F_CHARP(x)	(x)	/* how to convert F_CHARTYPE to a pointer to
				 * the real string */

/* max file name length - dataset names truncated to this size*/
#define MAX_FILE_NAME_LEN 14

#define ATT_UNIX 1
