.BG
.FN ts
.FN is.ts
.FN as.ts
.TL
Time-Series Objects
.CS
ts(data, start, frequency=1, end)
is.ts(x)
as.ts(x)
.AG data
vector giving the data values for the time-series.
.AG start
starting date for the series, in years, e.g., February, 1970
would be `1970+(1/12)' or `1970.083'.  If `start' is a vector
with at least two data values, the first is interpreted as
the year, and the second as the number of
positions
into the
year; e.g., February, 1970 could be `c(1970,2)'.
.AG frequency
observations frequency; that is, how many observations per year.
Monthly data has `frequency'=12; yearly has `frequency'=1.
.AG end
ending date for the series.
.PP
.AG x
any S object.
.RT
`ts' returns a time-series containing the given `data'.
Time-series attributes are assigned consistently with whichever of
`start', `end', and
`frequency' are supplied.
If only two of the three are given,
the other parameter will be computed based on the given values
and `length(data)'.
If both `start' and `end' are omitted, the series is started at 1.
`ts' checks that the the arguments supplied are consistent.
.PP
The function has been described as if the unit of time were one year.
However,
any periodic data can be organized as a time-series.
Hourly data might use days for `start' and `end' with `frequency'=24;
daily data could use weeks with `frequency=7'.
Internally, `frequency' is required to be a positive integer.
There is also special printing for
the cases of `frequency=1, 4' or `12' (see `prts').
.PP
`is.ts' returns `TRUE' if `x' is a time-series object, `FALSE' otherwise.
.PP
`as.ts' returns `x', if `x' is a time-series, otherwise `ts(x)'.
.PP
The time-series class of objects are those that have an attribute `tsp',
which must be numeric of length 3.
.KW ts
.KW classes
.WR
