#include <stdio.h>
#include "color.h"

#define DX		458
#define DY		441
#define FX		1
#define FY		474
#define FIRST_COLOR	1

int curpot, mixpot, mixbox = 0;
extern int Black[3];
static int d_on;

dinit()
{
	if(empty(&curpot, 1) == 0)
		return;
	dnumber(cur_color = FIRST_COLOR);
	dbox(34, 22, curpot);
	if(empty(&mixpot, 1) == 0)
		return;
	mixbox++;
	Dmove(0,6);
	alpha(YES);
	printf("mix:");
	graphics();
	hcopy(Colors[FIRST_COLOR].HLS, cur_mix);
	dmix(cur_mix);
	dbox(34, 0, mixpot);
	d_on++;
}

dnumber(color)
int color;
{
	int col;
	char read_pixel();

	Dmove(32,28);
	alpha(YES);
	printf("\b\b\b\b");
	if(betw(0, color, 255)) {
		if(Colors[color].known > 0)
			printf("%3d:", color);
		else
			printf("%3d ", color);
		graphics();
		col = color;
	} else {
		printf("   ?");
		graphics();
		move(511,511);
		read_pixel(&col, NO);
	}
	if(Colors[col].known > 0)
		set_table(curpot, Colors[col].HLS);
	else
		set_table(curpot, Black);
}

dmix(hls)
int *hls;
{
	set_table(mixpot, hls);
}

static int olength=50, ilength=0;

char *dfcn(fcn, input)
char *fcn;
int input;
{
	static char in[100];

	ferase(olength + ilength);
	alpha(YES);
	printf("\007%s%s", fcn, input == YES ? ": " : "");
	olength = strlen(fcn) + 2;
	graphics();
	if(input == NO) {
		ilength = 0;
		return(0);
	}
	alpha(YES);
	if(fgets(in,100,stdin) == NULL) {
		graphics();
		return(0);
	}
	graphics();
	ilength = strlen(in);
	return(in);
}

char next_cmd(msg)
char *msg;
{
	char c, *dfcn();
	int i;

	if(cmd_buf) {
		c = cmd_buf;
		cmd_buf = 0;
		return(c);
	}
	dfcn(msg, NO);
	raw();
	fflush(stdout); i = read(0, &c, 1);
	restore();
	return(i < 1 ? 0 : c);
}

derase()
{
	int background;
	char read_pixel();

	if(!d_on)
		return;
	ferase(olength + ilength);
	move(511,511);
	read_pixel(&background, NO);
	dbox(34, 22, background);
	dbox(34, 0, background);
	Dmove(32,28);
	alpha(YES);
	printf("\b\b\b\b");
	graphics();
	Dmove(32, 6);
	alpha(YES);
	printf("\b\b\b\b");
	graphics();
}

dbox(x, y, col)
int x, y, col;
{
	Dmove(x,y);
	set_cur_col(col);
	draw_rect(DX+x+17, DY+y+17);
}

ferase(n)
int n;
{
	Fmove(8*n, 0);
	alpha(YES);
	while(n--)
		putchar('\b');
	graphics();
}

Dmove(x,y)
int x, y;
{
	move(DX+x, DY+y);
}

Fmove(x,y)
int x, y;
{
	move(FX+x, FY+y);
}


dpalette()
{
	int length[258], color[258], i;

	dfcn("drawing palette...", NO);
	move(PX,PY);
	define_aoi(PX+19, PY-25);
	for(i = 0; i < 258; i++) {
		length[i] = 2;
		color[i] = 10 * (i/20) + i%10;
	}
	length[248] = length[249] = 2;
	color[248] = color[249] = 0;
	runs(length, color, 258);
	pal_drawn++;
}

int Darkblue[3] = {0,31,60};
int Red[3] = {120,50,100};
int Green[3] = {240,50,100};
int Blue[3] = {0,50,100};
int Yellow[3] = {180,50,100};
int Cyan[3] = {300,50,100};
int Magenta[3] = {60,50,100};
int White[3] = {0,100,100};
int Black[3] = {0,0,0};
int Bl_Mag[3] = {30,50,100};
int Mag_Red[3] = {90,50,100};
int Orange[3] = {150,50,100};
int Yel_Gr[3] = {210,50,100};
int Gr_Cy[3] = {270,50,100};
int Cy_Bl[3] = {330,50,100};

int list[14];

dcircle()
{
	if(empty(list, 14) < 14)
		return(1);
	dfcn("drawing circle...", NO);
	set_table(list[0], Blue);
	set_table(list[1], Magenta);
	set_table(list[2], Red);
	set_table(list[3], Yellow);
	set_table(list[4], Green);
	set_table(list[5], Cyan);
	set_table(list[6], Black);
	set_table(list[7], White);
	set_table(list[8], Bl_Mag);
	set_table(list[9], Mag_Red);
	set_table(list[10], Orange);
	set_table(list[11], Yel_Gr);
	set_table(list[12], Gr_Cy);
	set_table(list[13], Cy_Bl);
	move(CX, CY);
	write_pixel(list[6]);
	set_cur_col(list[6]);
	draw_circle(CRADIUS);
	blob(CX + CRADIUS, CY, list[0]);
	blob(CX + CRADCOS60, CY + CRADSIN60, list[1]);
	blob(CX - CRADCOS60, CY + CRADSIN60, list[2]);
	blob(CX - CRADIUS, CY, list[3]);
	blob(CX - CRADCOS60, CY - CRADSIN60, list[4]);
	blob(CX + CRADCOS60, CY - CRADSIN60, list[5]);
	blob(CX + CRADSIN60, CY + CRADCOS60, list[8]);
	blob(CX, CY + CRADIUS, list[9]);
	blob(CX - CRADSIN60, CY + CRADCOS60, list[10]);
	blob(CX - CRADSIN60, CY - CRADCOS60, list[11]);
	blob(CX, CY - CRADIUS, list[12]);
	blob(CX + CRADSIN60, CY - CRADCOS60, list[13]);
	circle_drawn++;
	return(0);
}

static int square[] = {3,0,0,6,4,4,6,0,0,3,-1};

blob(x, y, color)
int x, y, color;
{
	set_cur_col(color);
	move(x,y);
	chain(square);
}
