# plot an axis
FUNCTION axis(
	side		/INT/
	at		/REAL,OPTIONAL/
	labels		/ANY,OPTIONAL/
	ticks		/LGL,1,TRUE/
	distn		/CHAR,OPTIONAL/
	line		/REAL,1/
	pos		/REAL,1/
	outer		/LGL,1,FALSE/
	PAR
	)

define(`NNORM',16)
STATIC( CHARACTER(axt,1); CHARACTER(oaxt,1); real lin,axlin,probs(NNORM); integer leng,which,match,idist )
INITIAL( probs/.0001,.001,.005,.01,.02,.05,.1,.25,.5,.75,.9,.95,.99,.995,.999,.9999/ )
CTABLE( dists,normal )
if(outer) SPECIFY( omo(TRUE) )
QUERY( mgp(,lin,axlin), axt(side+1,oaxt), axt(side,axt), lab(,,leng) )
if(MISSING(line)) line=axlin
if(!MISSING(pos)) { side=-side; if(oaxt=="l") pos=alog10(pos); call zutomz(pos,side,line) }
if(!MISSING(distn)){
	idist=match(distn,dists)
	if(idist<1) ABORT("Distribution ",C(TEXT(distn))," not recognized")
	}
if(!MISSING(distn) & MISSING(at)){	# invent correct labels for distn
	if(idist==1) STRUCTURE(at/REAL,NNORM,probs/)
	MISSING(at)=FALSE
	}
if(MISSING(at)){	# put on a standard axis depending on axis type
	SPECIFY( mgp(,line+(lin-axlin),line) )
	if(MISSING(labels)) STRUCTURE(labels/LGL,1,TRUE/)
	else COERCE(labels/LGL/)
	if(axt=="s") call saxisz(side,ticks,labels)
	else if(axt=="t") call taxisz(side,ticks,labels)
	else if(axt=="l") call laxisz(side,ticks,labels)
	SPECIFY( mgp(,lin,axlin) )
	}
else {		# make up an axis from at, labels
	# make sure at values are sorted
	if(MISSING(labels)) call sort(at,LENGTH(at))
	else if(MODE(labels)==LGL) call sort(at,LENGTH(at))
	else if(LENGTH(labels)!=LENGTH(at))
		FATAL(Number of labels must match number of positions)
	else call sortp(at,LENGTH(at),labels)

	if(axt=="l"|!MISSING(distn)){	# transform according to distribution
		if(MISSING(labels)) {
			STRUCTURE(labels/REAL,LIKE(at)/)
			MISSING(labels)=FALSE
			}
		if(axt=="l") for(i=1; i<=LENGTH(at); i=i+1) at[i]=alog10(at[i])
		else for(i=1; i<=LENGTH(at); i=i+1) at[i]=qnorms(at[i])
		}

	if(MISSING(labels)) STRUCTURE(labels/LGL,1,TRUE/)
	SWITCH MODE(labels){
	CASE LGL:	# axis with ticks and/or labels
		if(labels)which=11; else which=0
		if(!ticks) which=-which
		if(ticks|labels) call vaxisz(side,line+(lin-axlin),line,at,at,at,LENGTH(at),leng,which)
	CASE CHAR:	# character labels
		if(LENGTH(labels)!=LENGTH(at))FATAL(Number of labels does not match number of positions)
		if(ticks) which=13; else which=-13
		call vaxisz(side,line+(lin-axlin),line,at,at,labels,LENGTH(at),leng,which)
	DEFAULT:	# encode numeric labels
		COERCE(labels/REAL/)
		if(LENGTH(labels)!=LENGTH(at))FATAL(Number of labels does not match number of positions)
		if(ticks) which=12; else which=-12
		call vaxisz(side,line+(lin-axlin),line,at,labels,labels,LENGTH(at),leng,which)
		}
	}
if(outer) SPECIFY( omo(FALSE) )
END
