#include <jerq.h>
#define abs(x) (x>0?x:-x)
#define WID 5

static short xmin,xmax,ymin,ymax,n;
extern Bitmap *Slayer;
Bitmap *previous;
static long sx,sy,sxx,sxy;

regn(x,y,narg)
short *x,*y,narg;
{
	short i;
	Point original,current;

	n = narg;
	xmin = Slayer->rect.origin.x;
	xmax = Slayer->rect.corner.x;
	ymin = Slayer->rect.origin.y;
	ymax = Slayer->rect.corner.y;
	previous = balloc(Rect(0,0,WID*2+1,WID*2+1));

	sx = sy = sxx = sxy = 0;

	for(i=0; i<n; i++)
		update(Pt(x[i],y[i]), 1);

	drawline();

	wait(MOUSE);
	for(;;){
		if(button1()){	/* start tracking */
			original = mouse.xy;
			current = original;
			bitblt(Slayer,	/* save original image */
				Rpt( sub(original,Pt(WID,WID)),
					add(original,Pt(WID,WID))),
				previous, Pt(0,0), F_STORE);
			rectf(Slayer,	/* invert original region */
				Rpt( sub(original,Pt(WID,WID)),
					add(original,Pt(WID,WID))),
				F_XOR);
			for(; button1(); ){
				drawline();	/* undraw */
				drawpt(current);	/* undraw point */
				update(current,-1);
				current = mouse.xy;
				update(current,1);
				drawpt(current);
				drawline();
				nap(2);
				}
			rectf(Slayer,	/* invert original region */
				Rpt( sub(original,Pt(WID,WID)),
					add(original,Pt(WID,WID))),
				F_XOR);
			}
		if(button23()) {
			while( button23() ) ;
			break;
			}
		}
	bfree(previous);
}

static update(pt,sign)
Point pt; short sign;
{
	if(sign>0){
		sx += pt.x;
		sy += pt.y;
		sxx += pt.x * pt.x;
		sxy += pt.x * pt.y;
		}
	else{
		sx -= pt.x;
		sy -= pt.y;
		sxx -= pt.x * pt.x;
		sxy -= pt.x * pt.y;
		}
}

static drawpt(p)
Point p;
{
	bitblt(previous, previous->rect, Slayer, sub(p,Pt(WID,WID)), F_XOR);
}

static drawline()
{
	long num,denom;
	short dx1,dx2,dy1,dy2,xmid,ymid;

	xmid = sx/n;
	ymid = sy/n;

	/* numerator and denominator for slope of least squares line */
	/* These formulas are safer for large problems (they won't overflow) */
	/* but they are less accurate because of the early division  */
	/* num = sxy - sx/n*sy; */
	/* denom = sxx - sx/n*sx; */
	num = sxy - sx*sy/n;
	denom = sxx - sx*sx/n;
	
	if(abs(num)>abs(denom)){	/* drive by y value */
		dx1 = (ymax-ymid)*denom/num;
		dx2 = (ymin-ymid)*denom/num;
		segment(Slayer, Pt(xmid+dx1, ymax), Pt(xmid+dx2,ymin), F_XOR);
	}
	else {	/* drive by x value */
		dy1 = (xmin-xmid)*num/denom;
		dy2 = (xmax-xmid)*num/denom;
		segment(Slayer, Pt(xmin, ymid+dy1), Pt(xmax,ymid+dy2), F_XOR);
	}

}
