FUNCTION boxcox(
	x	/REAL/
	y	/REAL/
	powers	/REAL,81/
	xpowers	/REAL,OPTIONAL/
	ypowers	/REAL,OPTIONAL/
	)

STATIC( integer xrmn,xrmx,yrmn,yrmx )
STATIC( POINTER ptr )
INCLUDE(graphics)

if(MISSING(powers))
	for(i=1; i<=LENGTH(powers); i=i+1)
		powers[i] = (-40 +(i-1))/10.
if(MISSING(xpowers))
	STRUCTURE(xpowers/REAL,LIKE(powers)/)
if(MISSING(ypowers))
	STRUCTURE(ypowers/REAL,LIKE(powers)/)

if(LENGTH(x)!=LENGTH(y)) FATAL(Lengths of x and y must match)

call rangev(x,LENGTH(x),xmn,xmx)
call rangev(xpowers,LENGTH(xpowers),pmn,pmx)
if(pmn<=0 & xmn<=0)
	FATAL(x data must be non-negative with negative or zero transformation powers)

call rangev(y,LENGTH(y),ymn,ymx)
call rangev(ypowers,LENGTH(ypowers),pmn,pmx)
if(pmn<=0 & ymn<=0)
	FATAL(y data must be non-negative with negative or zero transformation powers)

STRUCTURE(
	ip	/INT,max0(LENGTH(xpowers),LENGTH(ypowers))*LENGTH(x)/
	)

call cemit("E",2)	# send gs, E (erase)
call eatnl(4)		# eat 4 unwanted input lines
call cemit("b",1)	# b(boxcox)
call emit(LENGTH(x),1)
call emit(LENGTH(xpowers),1)
call emit(LENGTH(ypowers),1)

xrmn = am(22); xrmx = am(23)-6	# move so no point lies on box
call boxcox(x,LENGTH(x),xpowers,LENGTH(xpowers),xmn,xmx,ip,xrmn,xrmx)
call emit(ip,LENGTH(x)*LENGTH(xpowers))

yrmn = am(24)+20; yrmx = am(25)-6	# leave room at top for power display
# note the reversed raster coords -- y increases top to bottom
call boxcox(y,LENGTH(y),ypowers,LENGTH(ypowers),ymn,ymx,ip,yrmx,yrmn)
call emit(ip,LENGTH(y)*LENGTH(ypowers))

ptr = jstkgt(10*LENGTH(powers),CHAR)

nlab = 1
for(i=1; i<=LENGTH(xpowers); i=i+1){
	ENCODE(R(xpowers[i],0),C(EOS,1))
	call concat(cs(ptr),nlab,BUFFER,1,BUFPOS)
	nlab = nlab + BUFPOS
	CLEAR
	}
call emit(nlab-1,1)
call cemit(cs(ptr),nlab-1)

nlab = 1
for(i=1; i<=LENGTH(ypowers); i=i+1){
	ENCODE(R(ypowers[i],0),C(EOS,1))
	call concat(cs(ptr),nlab,BUFFER,1,BUFPOS)
	nlab = nlab + BUFPOS
	CLEAR
	}
call emit(nlab-1,1)
call cemit(cs(ptr),nlab-1)

END
