FUNCTION bxp(z/STR/, & )
ARGSTR(z)
ARG(
	stats		/MATRIX/
	conf		/MATRIX,OPTIONAL/
	n		/INT,NCOL(stats)/
	names		/CHAR,OPTIONAL/
	out		/REAL,OPTIONAL/
	group		/REAL,OPTIONAL/
	)
ARGSTR	# back to normal instr
ARG(
	width		/REAL,NCOL(stats)/
	varwidth	/LGL,1,FALSE/
	notch		/LGL,1,FALSE/
	old		/LGL,1,FALSE/
	ylim		/REAL,2/
	PAR
	&
	)
STATIC( logical same )
call beginz
nbox=NCOL(stats)
if(MISSING(n))call ifill(1,n,LENGTH(n))
if(notch & MISSING(conf))FATAL(Conf needed for notched boxes)
if(MISSING(width)){
	if(varwidth) for(i=1; i<=nbox; i=i+1) width[i]=sqrt(amax0(n[i],1))
	else call rfill(1.,width,nbox)
	}
if(MISSING(ylim)){
	call rangev(stats,LENGTH(stats),ylim[1],ylim[2])
	if(notch)call rangec(conf,LENGTH(conf),ylim[1],ylim[2])
	if(!MISSING(out))call rangec(out,LENGTH(out),ylim[1],ylim[2])
	}
call bxintz(ylim,1,2)	# set up for plotting
QUERY(cex(ocex))
call bxfors(stats, conf, nbox, n, width, notch, old)	# leaves cex set for points
if(!MISSING(out)){
	STRUCTURE( xout/REAL,LENGTH(out)/ )
	same=FALSE
	for(i=1;i<=LENGTH(out);i=i+1){
		ibox=group[i]
		call bxxvz(nbox,ibox,width,same,xout[i],hwid)
		same=TRUE
		}
	if(!old) { oldpch = am(15); am(15) = 1. }
	call pointz(xout,out,LENGTH(out))
	if(!old) am(15) = oldpch
	}
SPECIFY(cex(ocex))

STRUCTURE(mid/REAL,nbox/)
same = FALSE	# force bxxvz to re-initialize
for(i=1; i<=nbox; i=i+1) {
	call bxxvz(nbox,i,width,same,mid[i],hwid)
	same = TRUE
	}

if(!MISSING(names))call bxlabz(names,nbox,FALSE,width)
CHAIN(title,mid,PAR,FILTER)
END
