FUNCTION chull(&)
STRUCTURE(x,y)
PLOTARGS(NO_TS)
ARG(
	peel	/LGL,1,FALSE/
	maxpeel	/INT,1,LENGTH(x)/
	onbdy	/LGL,1,FALSE/
	tol	/REAL,1,.0001/
	)

STATIC(logical fail)
n=LENGTH(x); nct=n/3+1
if(n!=LENGTH(y)) FATAL(Lengths of x and y must match)
if(!MISSING(maxpeel)) peel=TRUE
STRUCTURE(
	theta	/REAL,n/
	order	/INT,n/
	nxt	/INT,n/
	prev	/INT,n/
	)

if(peel){
	STRUCTURE(
		depth	/INT,n/
		hull	/INT,n/
		count	/INT,min0(nct,maxpeel+1)/
		indx	/INT,n/
		)
	call chpeel(x,y,LENGTH(x),maxpeel,depth,hull,count,LENGTH(count),
		indx,theta,order,nxt,prev,tol)
	if(LENGTH(count)>maxpeel){ LENGTH(hull)=n-count[maxpeel+1]; LENGTH(count)=LENGTH(count)-1 }
	RETURN(depth,hull,count)
	}
else{
	call chull(x,y,n,theta,order,nxt,prev,onbdy,tol,LENGTH(prev),fail)
	if(fail) FATAL(All points colinear)
	RETURN(prev)
	}
END
