subroutine sclpro(x,n,xx,ac)
#  this subroutine transforms a symmetric matrix of dissimilaries (relative 
#  distances) to matrix of scalar products
real x(n,n),xx(n)
real ac,f,mean
#   transform dissimilarities (rel. dist.) to squared absolute distances
ac=addc(x,n)
do i = 2,n{
	do j = 1,i-1{
		x(i,j)=(x(i,j)+ac)**2
		x(j,i)=x(i,j)
		}
	}

#  transform absolute distances to scalar products by double centering matrix
for(i=1;i<=n;i=i+1){
	f=mean(x(1,i),n)
	for(j=1;j<=n;j=j+1) x(j,i)=x(j,i)-f
	}
for(i=1;i<=n;i=i+1){
	for(j=1; j<=n; j=j+1) xx(j)=x(i,j)
	f=mean(xx,n)
	for(j=1;j<=n;j=j+1) x(i,j)=-.5*(x(i,j)-f)
	}

return
end
