FUNCTION color(table/INT,MATRIX,OPTIONAL/, interact/LGL,1,F/)
INCLUDE(attach,read)
STATIC(integer out(256,4), size, i, ifile, ofile, sattac, sopen)
STATIC(POINTER cmdlin, intmp, outtmp, xmktmp)

NOPRINT
outtmp = NULL; intmp = NULL	# temporary files - zap at the end
outtmp = xmktmp(0)
ofile = sopen(TEXT(outtmp), WRITE)
if(ofile < 0)
	FATAL(cannot create temporary file)
call sclose(ofile)
ENCODE("S color -s -w ", C(TEXT(outtmp)))
if(!interact)
	ENCODE(" -i")
else if(MISSING(table))
	ENCODE(" -f")
if(!MISSING(table)) {
	if(NCOL(table) != 4)
		FATAL(input table should have 4 columns)
	intmp = xmktmp(0)
	ifile = sattac(TEXT(intmp), WRITE, AUTO)
	if(ifile < 0)
		FATAL(cannot create temporary file)
	ENCODE(" -r ", C(TEXT(intmp)))
	cmdlin = istrng(BUFFER, BUFPOS)
	CLEAR
	for(i = 1; i <= NROW(table); i = i + 1)
		FPRINT(ifile, I(table[i,1]), I(table[i,2]),
				I(table[i,3]), I(table[i,4]))
} else
	cmdlin = istrng(BUFFER, BUFPOS)
call excmd(TEXT(cmdlin), -1)
ofile = sattac(TEXT(outtmp), READ, AUTO)
call ifill(0, out, 256)
repeat {
	GETLINE(ofile)
	if(EOF) break
	DECODE(I(i))
	i = i + 1
	out(i,1) = 1
	DECODE(I(out(i,2)), I(out(i,3)), I(out(i,4)))
}
size = 0
for(i = 1; i <= 256; i = i + 1)
	if(out(i,1) == 1)
		size = size + 1
STRUCTURE(ntable/INT,MATRIX,size,4/)
size = 0
for(i = 1; i <= 256; i = i + 1)
	if(out(i,1) == 1) {
		size = size + 1
		ntable[size,1] = i - 1
		ntable[size,2] = out(i,2)
		ntable[size,3] = out(i,3)
		ntable[size,4] = out(i,4)
	}
if(intmp!=NULL) call xunlnk(TEXT(intmp))
if(outtmp!=NULL) call xunlnk(TEXT(outtmp))
RETURN(ntable)
END
