ROUTINE(discr,		multiple discriminant analysis)
subroutine discr(x,ndim,p,nn,k,vgr,coef,d)
integer ndim,k,p,nn(k); real x(ndim,p),vgr(k,k),coef(p,p),d(1)
#x: ndim by p matrix of data
#nn: vector of k group sizes 1st nn(1) rows in 1st gp, etc.
#vgr: returns with columns as linear combinations of groups
#coef: returns with columns as linear combinations of variables
#d: discriminant coefficients (correlations)

INCLUDE(stack)
POINTER jq,jv,jx,jw

call rfill(0.,d,k)
jq=jstkgt(p*(2*ndim+p+k),REAL); jx=jq+ndim*p; jv=jx+ndim*p; jw=jv+p**2
# orthogonalize, solve orthogonal, backsolve
call dev(x,ndim,ndim,p,rs(jx),rs(jv))
call gs(rs(jx),ndim,p,rs(jq),rs(jv))
call discro(rs(jq),ndim,p,nn,k,vgr,d,coef,rs(jw))
call backsu(rs(jv),p,p,coef,p,coef)

call matp(x,ndim,ndim,p,coef,p,p,rs(jx),ndim) #the transformed variables
call discwv(rs(jx),ndim,p,nn,k,rs(jv)) # the within variances
do j=1,p {
	sdev=rs(jv+j-1)
	if(sdev<=0.)next
	sdev=sqrt(sdev)
	do i=1,p
		coef(i,j)=coef(i,j)/sdev
	}

call jstkrl(1)
return
end

#discro      discriminant analysis of orthogonal data
subroutine discro(x,ndim,p,nn,k,vgr,d,v,w)
integer ndim,p,k,nn(k); real x(ndim,p),vgr(k,k),d(1),v(p,p),w(p,k)
real mean,fn; integer i,j,n1

n1=1
for(i=1; i<=k; i=i+1) {
	fn=sqrt(float(nn(i)))
	for(j=1; j<=p; j=j+1)
		w(j,i)=fn*mean(x(n1,j),nn(i))
	n1=n1+nn(i)
	}
call svd(w,p,k,v,p,d,vgr,k)

return
end

#discwv		within-group variances
subroutine discwv(x,n,p,nn,k,vars)
integer n,p,k,nn(k); real x(n,p),vars(p)
call rfill(0.,vars,p)
nobs=1
do i=1,k {
	do j=1,p
		vars(j)=vars(j)+float(nn(i)-1)*var(x(nobs,j),nn(i))
	nobs=nobs+nn(i)
	}
fn=1./float(n-1)
do j=1,p
	vars(j)=vars(j)*fn
return
end
