ifelse(OpSys,ATT,
`#include <sys/ioctl.h>
#include <termio.h>',
`#include <sgtty.h>')
#include <stdio.h>
#include <signal.h>

F77_SUB(zquxyz,int=xa,int=ya,int=indic)
{
	r_zquxyz(F_INTP(xa),F_INTP(ya),F_INTP(indic));
}

static r_zquxyz(xa,ya,indic)
long *xa, *ya, *indic;
{
	int x,y,t,nx,ny,i,ox,oy;

	int typed, (*istat)();
	struct ifelse(OpSys,ATT,termio,sgttyb) iostr;
	int oflags; unsigned short lflag;

	istat = signal(SIGINT,SIG_IGN);	/* ignore break */

ifelse(OpSys,ATT,
	`ioctl(0, TCGETA, &iostr);
	lflag = iostr.c_lflag;
	iostr.c_lflag &= ~ECHO;
	ioctl(0,TCSETAF, &iostr);',
	`ioctl(0, TIOCGETP, &iostr);
	oflags = iostr.sg_flags;
	iostr.sg_flags &= ~ECHO;
	ioctl(0, TIOCSETP, &iostr);')

	fprintf(stderr,"\033*dK");	/* graph cursor on */
	fprintf(stderr,"\033-zd1n3M");	/* touch screen report touch, release */
	for(i=0;;i++){
		t=0;
		ox = x; oy = y;
		scanf("\033-z%dx%dy%dtQ\n",&x,&y,&t);
		switch(t){
		case 0: goto out;
		case 3:
			if(abs(x-ox)+2*abs(y-oy)<10) {
				nx += (x-ox)*3;
				ny += (oy-y)*3;
				}
			else {
				nx = x*6+25;
				ny = (25-y)*15+25;
				}
			fprintf(stderr,"\033*d%3d,%3dO",nx,ny);
			break;
		case 4: x = 0; y=0;
			goto out;
			}
		}

out:
	*xa = nx; *ya=ny; *indic = t>0?1:-1;

	fflush(stderr);
	write(2,"\033-z0N\033*dL",9);	/* cursor and touch screen off */
	while( getchar()!='\n' );	/* skip extra new line */
	ifelse(OpSys,ATT,
		`iostr.c_lflag = lflag;
		ioctl(0, TCSETA, &iostr);',
		`iostr.sg_flags = oflags;
		ioctl(0, TIOCSETP, &iostr);')
		istat=signal(SIGINT,istat);
}
