#hp-gl device function for 7220, 7225, etc
FUNCTION hpgl(
	width	/REAL,1,10./
	height	/REAL,1,8./
	ask	/LGL,1,TRUE/
	auto	/LGL,1,FALSE/
	color	/INT,1,0/
	speed	/REAL,1,400./
	)
STATIC(logical streq)
STRUCTURE(parms/REAL,6/)	# w,h,ask,auto,color,speed

if(streq(TEXT(FNAME),TSTRING(hp7220v))){
	if(MISSING(width)) width=8
	if(MISSING(height)) height=10
	if(MISSING(color)) color=2	# automatic
	}
else if(streq(TEXT(FNAME),TSTRING(hp7220h))){
	if(MISSING(color)) color=2
	}
else if(streq(TEXT(FNAME),TSTRING(hp7470))
		| streq(TEXT(FNAME),TSTRING(hp7475))){
	if(MISSING(width)) width=10
	if(MISSING(height)) height=7.25
	if(MISSING(color)) color=2	# automatic
	}
else if(streq(TEXT(FNAME),TSTRING(hp7550))){
	if(MISSING(width)) width=10
	if(MISSING(height)) height=7.25
	if(MISSING(color)) color=2	# automatic
	if(MISSING(ask)) ask=FALSE
	if(MISSING(auto)) auto=!ask	# automatic frame advance default
	}

parms[1]=width
parms[2]=height
if(ask) parms[3]=1; else parms[3]=0
if(auto) parms[4]=1; else parms[4]=0
parms[5]=color
parms[6]=speed/10.

DEVICE_DRIVER(hpgl)
RETURN(parms)
END
