#doops		carry out arith, logic, bit operations
subroutine doops(n1,value1,n2,value2,mode,n,value,whichf,naflag)
POINTER value1,value2,value; integer n1,n2,mode,n,whichf; logical naflag
# n1, n2, length of input
# value1, value2: pointers to input
# mode: mode of input (& of output for arith)
# value: pointer to output
# whichf: code for which operator to do
#naflag: output, flag returned as TRUE if any NA's were generated

define(`NA_ACTION',`{naflag=TRUE; NASET(is(k)); next}')# generate a missing value
INCLUDE(struct, stack,arith)
POINTER k1,k2,k,break1,break2,brkout
real x,x1,x2; integer ix,ix1,ix2,chcomp; logical lx,lx1,lx2

if(whichf>NARITHOP) icase=mode*7; else icase=mode
naflag=FALSE; k1=value1-1; k2=value2-1
break1=value1+n1; break2=value2+n2; brkout=value+n
for(k=value; k<brkout; k=k+1) {
	k1=k1+1; k2=k2+1
	if(k1>=break1)k1=value1	# cycle through first set
	if(k2>=break2)k2=value2	# cycle through second set
	#do it
	if(NAVALUE(k1)|NAVALUE(k2)) { NASET(is(k)); next}
	switch( icase ) {
	case REAL: x1=rs(k1); if(whichf!=IPWR_OP) x2=rs(k2)
		switch(whichf) {
		case ADD_OP: x=x1+x2
		case SUB_OP: x=x1-x2
		case MUL_OP: ax1=amax1(abs(x2),abs(x2)); ax2=amin1(abs(x1),abs(x2))
			if(ax1>1.) if(BIG/ax1 < ax2)NA_ACTION
			x=x1*x2
		case DIV_OP: ax1=abs(x1);ax2=abs(x2)
			if(ax2<1.) if(ax2*BIG <= ax1)NA_ACTION #includes case x1==x2==0.
			x=x1/x2
		case MOD_OP: if(x2==0.) x=x1
			else{
				x=x1/x2		# floor x1/x2
				if(x<0. & aint(x)-x>PRECISION) x=ifix(x)-1
				else x=ifix(x)
				x=x1-x*x2
				}
		case PWR_OP: if(x1<=0. )NA_ACTION
				else if( x2 == 0.) x=1.
				else x=x1**x2
		case IPWR_OP:  x= x1 ** is(k2) # special operator set up by coerce
		case IDIV_OP: if(x2==0.)NA_ACTION
			x=aint(x1/x2)
			}
		rs(k)=x
	case eval(REAL*7): x1=rs(k1); x2=rs(k2)
		switch(whichf) {
		case LT_OP: lx=x1<x2
		case GT_OP: lx=x1>x2
		case LE_OP: lx= x1<=x2
		case GE_OP: lx= x1>=x2
		case EQ_OP: lx= x1==x2
		case NE_OP: lx = x1!=x2
			}
		ls(k)=lx
	case INT: ix1=is(k1); ix2=is(k2)
		switch(whichf) {
		case ADD_OP: ix=ix1+ix2
		case SUB_OP: ix=ix1-ix2
		case MUL_OP: ix=ix1*ix2
		case IDIV_OP: if(ix2==0.) NA_ACTION
			ix=ix1/ix2
		case MOD_OP: if(ix2==0) ix=ix1
			else{
				ix=ix1/ix2	# floor ix1/ix2
				if(float(ix1)/float(ix2)<0.&ix*ix2!=ix1) ix=ix-1
				ix=ix1-ix*ix2
				}
		case PWR_OP: ix=ix1**ix2
			}
		is(k)=ix
	case eval(INT*7): ix1=is(k1); ix2=is(k2)
		switch(whichf) {
		case LT_OP: lx=ix1<ix2
		case GT_OP: lx=ix1>ix2
		case LE_OP: lx= ix1<=ix2
		case GE_OP: lx= ix1>=ix2
		case EQ_OP: lx= ix1==ix2
		case NE_OP: lx = ix1!=ix2
			}
		ls(k)=lx
	case eval(LGL*7): lx1=ls(k1); lx2=ls(k2)
		switch(whichf) {
		case OR_OP: lx= lx1 | lx2
		case AND_OP: lx= lx1& lx2
			}
		ls(k)=lx
	case CHAR: FATAL(No arithmetic on characters)
	case eval(CHAR*7): ix1=chcomp(is(k1),is(k2))
		switch(whichf){
		case LT_OP: lx=ix1<0
		case GT_OP: lx=ix1>0
		case LE_OP: lx= ix1<=0
		case GE_OP: lx= ix1>=0
		case EQ_OP: lx= ix1==0
		case NE_OP: lx = ix1!=0
			}
		ls(k)=lx
		}
	}
return
end
