FUNCTION monthplot(
	y		/TS/
	labels		/ANY,OPTIONAL/
	prediction	/INT,1,1/
	PAR
	&
	)

CTABLE(year,Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec)
CTABLE(quarts,First,Second,Third,Fourth)
STATIC(real lin,axlin; integer leng; CHARACTER(ax,1))

nper=int(TNPER(y))
iyear=int(TSTART(y))
imonth=(TSTART(y)-float(iyear))*nper+1.5
lyear=int(TEND(y))
lmonth=(TEND(y)-float(lyear))*nper+1.5
nyear=lyear-iyear+1

STRUCTURE(
	dvec	/REAL,nyear/
	xscr	/REAL,max0(nyear,nper)/
	yscr	/REAL,nyear/
	)

xmn=0; xmx=LENGTH(y)+nper+1
call rangev(y,LENGTH(y),ymn,ymx)
NO_TS
SETUP(xmn,xmx,ymn,ymx)

SPECIFY(usr(xmn,xmx,,))
call mplot(y,LENGTH(y),nper,iyear,imonth,lyear,lmonth,nyear,dvec,xscr,yscr,prediction)

QUERY( mgp(,lin,axlin), lab(,,leng) )
unit=(LENGTH(y)+nper)/float(nper)
for (i=1;i<=nper;i=i+1) xscr[i]=(float(i)-.5)*unit
if(MISSING(labels)){
	if(nper==12) STRUCTURE(labels/CHAR,12,year/)
	else if(nper==4)STRUCTURE(labels/CHAR,4,quarts/)
	else{
		STRUCTURE(labels/REAL,nper/)
		for (i=1;i<=nper;i=i+1) labels[i]=i
		}
	}
if(LENGTH(labels)!=nper)ABORT("There must be",I(nper)," labels")
SWITCH MODE(labels){
	CASE LGL: FATAL(labels must be character or numeric)
	CASE CHAR: call vaxisz(BOTTOM,lin,axlin,xscr,xscr,labels,nper,leng,-13)
	DEFAULT: COERCE(labels/REAL/)
		call vaxisz(BOTTOM,lin,axlin,xscr,labels,labels,nper,leng,-12)
	}
call saxisz(LEFT,TRUE,TRUE)
call boxz
CHAIN(title,PAR,FILTER)
END
