FUNCTION mulbar(
	width	/MATRIX/
	height	/MATRIX/
	rowlab	/CHAR,OPTIONAL/
	collab	/CHAR,OPTIONAL/
	gap	/REAL,1,.2/
	PAR
	&
	)
CHECK(NROW(width)==NROW(height) & NCOL(width)==NCOL(height),FATAL(width and height do not match))
for(i=1; i<=LENGTH(width); i=i+1) if(width[i]<0)FATAL(widths must be non-negative)
STRUCTURE(
	row	/REAL,NROW(width)/
	col	/REAL,NCOL(width)/
	)
call beginz
call mulbar(width,height,NROW(width),NCOL(width),row,col,gap)
if(!MISSING(rowlab)){
	QUERY( srt(srt) ); SPECIFY( srt(90) )
	lim=min0(LENGTH(rowlab),LENGTH(row))
	for(i=1; i<=lim; i=i+1) call gtextz(LEFT,1.,row[i],TEXT(rowlab[i]))
	SPECIFY( srt(srt) )
	}
if(!MISSING(collab)){
	QUERY( srt(srt) ); SPECIFY( srt(0) )
	lim=min0(LENGTH(collab),LENGTH(col))
	for(i=1; i<=lim; i=i+1) call gtextz(BOTTOM,1.,col[i],TEXT(collab[i]))
	SPECIFY( srt(srt) )
	}
CHAIN(title,PAR,FILTER)
END
