ROUTINE(napbst,		heap manipulation for napsack problem)
subroutine napbst(value,auxv1,auxv2,heap,k,aux1,aux2,count)
real value,heap(k)
integer auxv1,auxv2,k,aux1(k),aux2(k),count
# each time, takes one new value and aux info
# on first call, count should be 0
# when complete, the last count values in heap/aux are the smallest

if(count<k){ i=k-count; count=count+1 }
else if(value<heap(1)) i=1
else return

heap(i)=value
aux1(i)=auxv1; aux2(i)=auxv2
call napify(heap,aux1,aux2,i,k)
return
end

ROUTINE(napify,		maintain heap)
subroutine napify(heap,aux1,aux2,i,j)
real heap(j); integer aux1(j),aux2(j),i,j
# from Aho, Hopcroft, & Ullman "Design and Analysis
# of Computer Algorithms" (1974) p90

integer lstnod,now,k,atemp; real temp

lstnod=j/2
now=i
repeat{
	if(now>lstnod) return	# now is a leaf, thus a heap
	k=now*2	# find larger son
	if(k+1<=j)if(heap(k+1)>heap(k)) k=k+1
	if(heap(now)>=heap(k)) return	# father bigger than sons
	# interchange heap(k) with heap(now)
	temp=heap(now); heap(now)=heap(k); heap(k)=temp
	atemp=aux1(now); aux1(now)=aux1(k); aux1(k)=atemp
	atemp=aux2(now); aux2(now)=aux2(k); aux2(k)=atemp
	now=k
	}
end

ROUTINE(napsrt,		return the k smallest values sorted)
subroutine napsrt(heap,k,aux1,aux2,count)
real heap(k); integer aux1(k),aux2(k),k,count
real temp; integer atemp,i

if(count<k)FATAL(Must have processed at least k values)
for(i=k; i>=2; i=i-1){
	temp=heap(1); heap(1)=heap(i); heap(i)=temp	# position 1 is largest
	atemp=aux1(1); aux1(1)=aux1(i); aux1(i)=atemp
	atemp=aux2(1); aux2(1)=aux2(i); aux2(i)=atemp
	call napify(heap,aux1,aux2,1,i-1)	# now treat as heap of length i-1
	}
return
end
