FUNCTION plclust(
	tree	/STR/
	hang	/REAL,1,.1/
	unit	/LGL,1,FALSE/
	level	/LGL,1,FALSE/
	hmin	/REAL,1,0./
	square	/LGL,1,TRUE/
	labels	/ANY,OPTIONAL/
	plot	/LGL,1,TRUE/
	ylim	/REAL,2/
	PAR
	&
	)
STRUCTURE(
	merge	/MATRIX,INT,FROM(tree)/
	height	/REAL,FROM(tree)/
	order	/INT,FROM(tree)/
	)
mxleaf=0
for(i=1; i<=LENGTH(order);i=i+1) mxleaf=max0(mxleaf,order[i])
n=LENGTH(height)+1
STRUCTURE(
	xl	/REAL,mxleaf/
	yl	/REAL,mxleaf/
	xn	/REAL,n-1/
	yn	/REAL,n-1/
	axis	/LGL,1,TRUE/
	)
call treeco(merge[1,1],merge[1,2],height,order,n,mxleaf,unit,level,hmin,hang,xl,yl,xn,yn)
for(i=1;i<=mxleaf;i=i+1)
	if(xl[i]<0.) NASET(xl[i])	#flag leafs missing from subtree
RETURN(x=xl,y=yl,&)
if(plot){
	if(MISSING(ylim)){
		call rangev(yn,n-1,ylim[1],ylim[2])
		call rangec(yl,mxleaf,ylim[1],ylim[2])
		}
	call beginz
	QUERY( lab(lx,ly) )
	call stdaxz(LEFT," ",ylim[1],ylim[2],ly,2)
	 SPECIFY( usr(0.,float(n+1)) )
	call treepl(merge[1,1],merge[1,2],n,xl,yl,xn,yn,square)
	if(MISSING(labels))ALLOCATE(labels/LGL,1,TRUE/)
	CHAIN(labclust,axis,labels,xn,yn,PAR,FILTER)
	}
else RETURN(xn,yn)
END
