FUNCTION reg(
	x		/MATRIX/
	y		/MATRIX/
	wt		/REAL,OPTIONAL/
	int		/LGL,1,TRUE/
	print		/LGL,1,FALSE/
	names		/OPTIONAL/
	ynames		/OPTIONAL/
	q		/LGL,1,FALSE/
	correlation	/LGL,1,TRUE/
	)
STATIC( integer nvar,nc,nobs,ny,i,j; logical qflag,streq )
qflag=q
if(NROW(x)!=NROW(y))FATAL(Different numbers of observations in x and y)
nvar=NCOL(x)
if(int)nc=nvar+1
else nc=nvar
nobs=NROW(x)
ny=NCOL(y)
ALLOCATE(q/MATRIX,nobs,nc/)
STRUCTURE(
	coef		/MATRIX,nc,ny/
	resid		/LIKE(y)/
	r		/MATRIX,nc,nc/
	corth		/MATRIX,nc,ny/
	work		/REAL,3*nc/
	)
if(MISSING(wt))
	call gslsi(x,nobs,nvar,y,ny,q,r,corth,coef,nc,resid,int,work)
else {
	if(ny!=1)WARNING(Same weights for several regressions may not make sense)
	if(LENGTH(wt)!=nobs)FATAL(wrong number of weights)
	for(i=1;i<=nobs;i=i+1)
		if(wt[i]>0.)wt[i]=sqrt(wt[i])
		else if(wt[i]<0.)FATAL(negative weights not allowed)
	call gslsiw(x,nobs,nvar,y,ny,wt,q,r,corth,coef,nc,resid,int,work)
	}
if(ny==1) {
	COERCE(coef/VECTOR/)
	COERCE(resid/VECTOR/)
	COERCE(corth/VECTOR/)
	}
RETURN(coef,resid,r,corth,int,&)
if(qflag)RETURN(q,&)
if(!MISSING(names))RETURN(names,&)
if(!MISSING(ynames))RETURN(ynames,&)
if(!MISSING(wt))RETURN(sqrtw=wt,&)
if(!MISSING(correlation))RETURN(correlation,&)
if(print|(MISSING(print) & streq(TEXT(fname),TSTRING(regress)))) { # set up regr. str., call printing
	STRUCTURE(z/STR,1/)
	VALUE(z)=outstr #collect all args
	outstr=alcdir(1,fname,TFUN) # new result structure
	nres=0; RETURN(z,&) # return z as only arg.
	CHAIN(regprt)
	}
END
