#bqnorm    bqnorm - return std norm quantile for given probability
real function bqnorm(p)
#
data one/1.0/
#
#  set up for p.lt.0.5
r = p
ix = 1
q = 1.0-p
#
#  look for extreme probabilities
if (r<=0)
	bqnorm = -7.0
else
#
 if (1.<=r)
	bqnorm = 7.0
else {
#
	if (r>=0.5)
#
		if (r==0.5) {
#
			bqnorm = 0.0
			return
			}
		else {
#
#  set up for p.gt.0.5
			r = 1.0-r
			ix = 2
			q = p
			}
#
	if (r<1.0e-10)
		x = 6.41
	else {
#
#  hastings approximation + 2 steps of newton-raphson correction
		t = sqrt(alog(one/(r*r)))
		u = (0.010328*t+0.802853)*t+2.515517
		v = ((0.001308*t+0.189269)*t+1.432788)*t
		x = t-u/(v+1.0)
		do i = 1,2
			x = x-(bpnorm(x)-q)/(.3989422804*exp(-0.5*x*x))
		}
#
	switch(ix) {
		case 1:
			bqnorm = -x
		case 2:
			bqnorm = x
		}
	}
return
end



