#crreg    crreg - robust weighted regression with zero intercept
subroutine crreg(x,y,n,ndim,k,ith,itb,xh,xb,calp,crsq,wt,cres)
real x(ndim,1),y(1),calp(1),wt(1),cres(1)
integer in(2)
#
#  robust regression such that x, y are unchanged and cres nis small.
#  dimension for cres nis max(n,k*k). residuals are returned in cres.
#  do ith huber weight steps and then itb bisquare weight steps.
#  set regression parameters as follows-
#     if both nith and nitb are le 0 use defaults, 5 and 3
#     if nith or nitb are lt 0 also use defaults
#     use default of 2 if xk le 0, of 6 if xb le 0
#
#  sabl error flag
common/errcm/ierr
#
#
data one/1.0/
#
#  check argument values
nith = ith
nitb = itb
xk = xh
xbw = xb
if (nith<=0&&nitb<=0) {
	nith = 5
	nitb = 3
	}
if (xk<=0.)
	xk = 2.
if (xbw<=0.)
	xbw = 6.
if (nith<0)
	nith = 5
if (nitb<0)
	nitb = 3
#
#  in contains partial sort parameters to find median using xmed
in(1) = n/2
in(2) = in(1)+1
#
#  initialize robust regression with unweighted least squares
call brput(one,wt,n)
call crwls(x,y,(n),(ndim),k,wt,calp,cres)
if (ierr!=2) {
#
#  loop for huber regression
	if (nith!=0)
		do j = 1,nith {
			call absv(cres,(n),wt)
			call sortx(wt,(n),in,2)
			xmad = xmed(wt,n)*1.5*xk
			call absv(cres,(n),wt)
			do i = 1,n
				if (wt(i)>xmad)
					wt(i) = xmad/wt(i)
				else
					wt(i) = 1.
			call crwls(x,y,(n),(ndim),k,wt,calp,cres)
			if (ierr==2)
				go to 10
			}
#
#  loop for bisquare regression
	if (nitb!=0)
		do j = 1,nitb {
			call absv(cres,(n),wt)
			call sortx(wt,(n),in,2)
			xmad = xmed(wt,n)*xbw
			call absv(cres,(n),wt)
			do i = 1,n
				if (wt(i)>xmad)
					wt(i) = 0.
				else
					wt(i) = (1.-(wt(i)/xmad)**2)**2
			call crwls(x,y,(n),(ndim),k,wt,calp,cres)
			if (ierr==2)
				go to 10
			}
#
#  calculate r**2 like precision estimate of regression
	call crrs(cres,y,wt,(n),crsq)
	if (ierr!=2)
		return
	}
#
#  error
10  continue
return
end



