#meast    meast - get month,day of western easter given the year
subroutine meast(iyear,month,iday)
#
month = 4
iday = 0
if (iyear>1582&&iyear<5000) {
#
#  from communications of the acm, vol.5, no.3, p.209, march 1962
#  easter nis first sunday after the first full moon on or after 3/21
#  igold=number of the year in metonic cycle, to determine calendar moon
	igold = mod(iyear,19)+1
#
#  gregorian correction for omission of century leap years
	icent = iyear/100+1
	igreg = (3*icent)/4-12
#
#  clavian correction for metonic cycle
	iclav = (icent-16-(icent-18)/25)/3
#
#  iedays nis when sunday occurs in march
	iedays = (5*iyear)/4-igreg-10
#
#  iepact specifies when the first full moon occurs on or after 3/21
	iepact = mod(11*igold+20+iclav-igreg,30)
	if (iepact<=0)
		iepact = iepact+30
	if (iepact==25&&igold>11||iepact==24)
		iepact = iepact+1
#
	iday = 44-iepact
	if (iday<21)
		iday = iday+30
	iday = iday+7-mod(iedays+iday,7)
	if (iday<=31)
		month = 3
	if (iday>31)
		iday = iday-31
	}
return
end



#mdow  mdow - get day of week 1..7 (mon..sun).  ok for all years a.d.
integer function mdow(iyear,month,iday)
#
ix = iyear+(month-14)/12
kx = (13*(month+10-((month+10)/13)*12)-1)/5+iday+77+5*(ix-(ix/100)*100)/4+ix/400-(ix/100)*2
mdow = mod(kx-1,7)+1
return
end



#mleap   mleap   =1 if leap year, else = 0.  ok for gregorian
integer function mleap(iyear)
#
mleap = 0
if (mod(iyear,4)==0) {
	mleap = 1
	if (mod(iyear,100)==0)
		if (mod(iyear,400)!=0)
			mleap = 0
	}
return
end



