#pfit     pfit - get regression for powers of data
subroutine pfit(xml,nn,ncyc,powvec,npowv,powt,powout)
#
real xml(1),powvec(1),powt(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#  check argument values
if (npowv<=0) call ewrt(166)
npc = ncyc
if (ncyc<=1)  npc = 12
if (nn<npc*3) call ewrt(162)
#
#  set odd- length smoother
ntp = 2*npc+1
#
#  initialize
npp = npc-1
nms = nn-npp*2
imo = 1
iyear = 1
lmo = mod(nms-1,npc)+1
lyear = (nms+npp)/npc
#
#  get work space. ib1 for y, x of regression.
#  ib2 for midmeans. ib3 for scaled data.
#  ib4 for bisquare weights. ib5 for scratch
i = npc+ntp+4*nn
ib1 = jstkgt(i,3)
ib6 = jstkgt(npc,2)
ibx = ib1+nn
ib2 = ib1+nn*2
ib3 = ib2+npc
ib4 = ib3+nn
ib5 = ib4+ntp
ib1m = ib1-1
ibxm = ib1m+nn
ib2m = ib2-1
ib5m = ib5-1
#
#  scale data for computational stability
call rangv(xml,nn,avgs,avgt)
avgs = abs(avgs)
avgt = amax1(avgs,avgt)
call rdiv(avgt,xml,nn,rs(ib3))
#
#  get bisquare weights
call biswt(ntp,rs(ib4))
#
#  cycle over powers
do ip = 1,npowv {
#
#  transform
	powio = powvec(ip)
	call ptr(rs(ib3),nn,powio,rs(ib1))
	if (ierr>=2) {
		if (ierr==3) powout = powio
		goto 60
		}
#
#  get trend.  loses 2*npc-2
	call dmm(rs(ib1),nn,npc,rs(ib5))
	if (ierr==2) goto 60
	call dma(rs(ib5),nn-npp,npc,rs(ib5))
	call dwls(rs(ib5),nms,ntp,rs(ib4),1,nms,0,rs(ib2),rs(ib2),1,rs(ibx))
	if (ierr==2) goto 60
#
#  get residuals from trend.
	k = ib1+npp
	call subt(rs(k),rs(ibx),nms,rs(ib1))
#
#  get seasonal = monthly midmean
	call mmidn(rs(ib1),imo,iyear,lmo,lyear,npc,is(ib6),rs(ib2))
	if (ierr==2) goto 60
#
#  get y=residuals and x=seasonal*trend deviations
	avgt = sumx(rs(ibx),nms)/float(nms)
	avgs = sumx(rs(ib2),npc)/float(npc)
	call radd(-avgs,rs(ib2),npc,rs(ib5))
	do m = 1,npc {
		j = ib2m+m
		jj = ib5m+m
		do i = m,nms,npc {
			k = ib1m+i
			rs(k) = rs(k)-rs(j)
			k = ibxm+i
			rs(k) = (rs(k)-avgt)*rs(jj)
			}
		}
#
#  measure correlation by robust regression
	call prreg(rs(ibx),rs(ib1),nms,powt(ip))
	if (ierr==2) goto 60
	avgs = abs(powt(ip))
	if (ip>1 && avgs>=tmin) next 1
	powout = powvec(ip)
	tmin = avgs
	}
#
#  release working space
60  call jstkrl(2)
return
end
