#ptri     ptri - inverse power transformation of xtadj into xadj
subroutine ptri(xtadj,nn,powout,xadj)
real xtadj(1),xadj(1)
#
#  sabl error flag
common/errcm/ierr
#
if (nn<=0) {
	ierr = 2
	ierrno = 164
	call ewrt(ierrno)
	}
else {
#
	zero = zrol(zl)
	if (abs(powout-1.0)<zero)
#
#  transformation power = 1.0
		call rmovf(xtadj,(nn),xadj)
	else {
		if (abs(powout)<zero) {
#
#  transformation power = 0.
			sz = I1MACH(10)
			sz = alog(sz)*float(I1MACH(13)-3)
			do i = 1,nn {
				if (abs(xtadj(i))>sz)
					go to 10
				xadj(i) = exp(xtadj(i))
				}
			return
			}
		else if (abs(powout+1.0)<zero) {
#
#  transformation power = inverse
			sz = I1MACH(10)
			sz = sz**(I1MACH(12)+2)
			do i = 1,nn {
				if (abs(xtadj(i))<sz)
					go to 10
				xadj(i) = -1.0/xtadj(i)
				}
			return
			}
		else if (powout<0.) {
#
#  transformation power not log, asis or inverse.  pow.lt.0
			pinv = 1.0/powout
			do i = 1,nn {
				if (xtadj(i)>=0.)
					go to 10
				xadj(i) = (-xtadj(i))**pinv
				}
			return
			}
		else {
#
#  transformation power not log, asis or inverse.  pow.gt.0
			pinv = 1.0/powout
			do i = 1,nn {
				if (xtadj(i)<0.)
					go to 10
				xadj(i) = xtadj(i)**pinv
				}
			return
			}
#
#  error
		10  ierr = 2
		ierrno = 160
		call ewrt(ierrno)
		}
	}
return
end



