ROUTINE(tsamp,		random sample using hash table)
subroutine tsamp(x,n,size)
integer size,x(size),n
# use when size < n/3   (otherwise use rsamp)
# space required: 3*size;   number of random uniforms: ~2*size

INCLUDE(stack)
integer nprime,tlen,this,jump,i,j
POINTER jstkgt,table

tlen=nprime(size*2)
table=jstkgt(tlen,INT)	# allocate hash table (prime length)
call ifill(0,is(table),tlen)

for(i=0; i<size; ){
	j=min0(ifix(uni(0)*float(n))+1,n)	# uniform on [1,n]
	this=mod(j,tlen)	# first loc in hash table probe
	jump=max0(1,mod(j/tlen,tlen))	# increment for collisions
	repeat{
		if(is(table+this)==j) next 2	# already used
		if(is(table+this)==0) {is(table+this)=j; break }	# new, enter in table
		this=mod(this+jump,tlen)	# collision, try again
		}
	i=i+1
	x(i)=j
	}

call jstkrl(1)

return
end
