FUNCTION scale( x/MATRIX,NAOK/
	center/REAL,NCOL(x)/
	scale/REAL,NCOL(x)/
	)

STATIC( real mean,dotv; integer n,p,i,j,nn)
STATIC( logical means,sdevs,docent,doscal)

n=NROW(x); p=NCOL(x)
STRUCTURE(xx/REAL,n/)

if(MISSING(center)) {means=TRUE; docent=TRUE}
else if(LENGTH(center)==1) {
	means=center[1]!=0.; docent=means
	if(p==1)WARNING(Single column matrix centered by means)
	}
else if(LENGTH(center)==p){ means=FALSE; docent=TRUE }
else FATAL(Length of center vector must match columns of x)
if(docent & means) ALLOCATE(center/REAL,p/)

if(MISSING(scale)) {sdevs=TRUE; doscal=TRUE}
else if(LENGTH(scale)==1) {
	sdevs=scale[1]!=0.; doscal=sdevs
	if(p==1)WARNING(Single column matrix scaled by standard deviation)
	}
else if(LENGTH(scale)==p){ sdevs=FALSE; doscal=TRUE }
else FATAL(Length of scale vector must match columns of x)
if(doscal & sdevs) ALLOCATE(scale/REAL,p/)

for(j=1; j<=p; j=j+1) {
	call nacopy(x[1,j],1,n,xx,nn) #copy, remove NA's, nn is the count
	if(nn==0) next
	if(means)center[j]=mean(xx,nn)
	if(docent) for(i=1; i<=nn; i=i+1) xx[i]=xx[i]-center[j]
	
	if(sdevs)scale[j]=sqrt(dotv(xx,nn,xx)/amax0(1,nn-1))
	if(doscal && scale[j]!=0.) for(i=1; i<=nn; i=i+1) xx[i]=xx[i]/scale[j]
	call naback(xx,nn,x[1,j],1) # copy back adjusted values
	}
RETURN(x)
END
