FUNCTION scatmat(
	data	/MATRIX/
	names	/CHAR,NCOL(data)/
	labels	/CHAR,1/
	scale	/LGL,1,TRUE/
	)

STRUCTURE(
	ndata	/MATRIX,INT,NROW(data),NCOL(data)/
	mins	/REAL,NCOL(data)/
	ranges	/REAL,NCOL(data)/
	status	/INT,NROW(data)/
	category	/CHAR,4/
	)

if(LENGTH(names)!=NCOL(data)) FATAL(names must match columns of data)
if(MISSING(labels)) LENGTH(labels)=0
else if(LENGTH(labels)!=NROW(data)) FATAL(labels must match rows of data)

for(i=1; i<=NCOL(data); i=i+1)
	call sform(data[1,i], NROW(data), ndata[1,i], scale, mins[i], ranges[i])

if(MISSING(names)){
	for(i=1; i<=LENGTH(names); i=i+1){
		ENCODE("Var",I(i))
		names[i]=istrng(BUFFER,BUFPOS)
		CLEAR
		}
	}

call scatmt(ndata, NROW(data), NCOL(data),
	names, LENGTH(names), labels, LENGTH(labels), mins, ranges, status)

NOPRINT
category[1]=STRING(Normal)
category[2]=STRING(Highlighted)
category[3]=STRING(Labelled)
category[4]=STRING(Deleted)
RETURN(Label=category,Data=status)
END
