#mfcalc		calculate basic math functions
subroutine mfcalc(pdata,whichf,naflag,dec)
POINTER pdata; integer whichf,dec; logical naflag
#pdata: pointer to entry for data vector
#whichf: code for function
#naflag: to be set to TRUE if NA's generated
#dec: no. of decimal places (used in round only)

define(`TRIG_LIMIT',1.e6)define(`EXP_LIMIT',80)
define(`NA_ACTION',`{naflag=TRUE; NASET(is(k)); next}')
INCLUDE(struct, stack,mathfu)
POINTER brkout,k; integer dmode; real x

naflag=FALSE
switch(MODE(pdata)) {# do needed coercing, skip null operations
case LGL,INT: switch(whichf) {
	case CEIL_FUN, FLOOR_FUN, TRUNC_FUN: return
	case ABS_FUN: dmode=INT
	default: dmode=REAL
		}
	call coeves(pdata,pdata,dmode,TRUE)
case REAL: #leave alone
case CHAR: FATAL(characters illegal with math function)
	}
if(whichf==ROUND_FUN) pwr=10.**dec
brkout=VALUE(pdata)+LENGTH(pdata)
for(k=VALUE(pdata); k<brkout; k=k+1) {
	if(NAVALUE(k))next
	switch( whichf/10) {# type of function
	case FULL_RANGE: switch(whichf) {
		case ABS_FUN: if(MODE(pdata)==INT) is(k)=iabs(is(k))
			else rs(k)=abs(rs(k))
		case CEIL_FUN: x=aint(rs(k))
			if(rs(k)>0) {
				if(x==0.)x=1.
				else if( rs(k)-x > PRECISION)x=x+1. #round up
				}
			rs(k)=x
		case FLOOR_FUN: x=aint(rs(k))
			if(rs(k)<0) {
				if(x==0.) x= -1.
			else if(x-rs(k) > PRECISION) x=x-1. # round down
				}
			rs(k)=x
		case ROUND_FUN: rs(k)=sign( aint( abs(rs(k))*pwr+.5)/pwr,rs(k))
		case TRUNC_FUN: rs(k)=aint(rs(k))
			}
	case LOG_TYPE: if( rs(k)<= 0.)NA_ACTION
		switch( whichf) {
		case LOG_FUN: rs(k)=alog(rs(k))
		case LOG10_FUN: rs(k)=alog10(rs(k))
			}
	case TRIG_TYPE: if(abs(rs(k))>TRIG_LIMIT)NA_ACTION
		switch(whichf) {
		case SIN_FUN: rs(k)=sin(rs(k))
		case COS_FUN: rs(k)=cos(rs(k))
			}
	case MISC_TYPE: switch(whichf) {
		case EXP_FUN: x=rs(k); if( x> EXP_LIMIT)NA_ACTION
			else if(x < -EXP_LIMIT)rs(k)=0.
		else rs(k)=exp(x)
		case SQRT_FUN: if(rs(k)<0)NA_ACTION
			else rs(k)=sqrt(rs(k))
			}
	case ATRIG_TYPE: if(abs(rs(k))>1.)NA_ACTION
		switch(whichf) {
		case ASIN_FUN: rs(k)=asin(rs(k))
		case ACOS_FUN: rs(k)=acos(rs(k))
			}
		}
	}
return
end
