FUNCTION tprint(
	Label=	/STR,OPTIONAL/
	mincol=	/INT,1/
	maxcol=	/INT,1/
	& )

STRUCTURE( var , mode/INT,NARGS/, value/INT,NARGS/, name/INT,NARGS/ )
STATIC( logical ok; integer ndim, nvar; POINTER yenter)
nvar=0
ALLARG(var) #other arguments are tables
	COERCE( var/ANY,ARRAY,NAOK/)
	if( MISSING(Label)) STRUCTURE( Label/FROM(var),STR,OPTIONAL/)
	if(nvar==0) { #initialize
		STRUCTURE(Dim/FROM(var),INT/ )
		ndim=LENGTH(Dim)
		}
	else { #check consistency
		STRUCTURE( newdim/FROM(var,Dim),INT/)
		ok=TRUE
		if(LENGTH(newdim)==ndim) {
			for(i=1;i<=ndim;i=i+1)
				if(Dim[i]!=newdim[i]){ ok=FALSE; break }
			}
		else ok=FALSE
		if(!ok) FATAL(All tables must have identical dimensions)
		}
	nvar=nvar+1
	value[nvar]=VALUE(var); mode[nvar]=MODE(var)
	if(NAME(P(var))!=NULL)name[nvar]=NAME(P(var)); else name[nvar]=DATANAME(var)
NEXTARG

if(MISSING(Label))FATAL(Must supply table or label structure)
if(LENGTH(VALUE(Label))!=ndim)FATAL(Label structure must have same number of categories as tables)
if(ndim==1){	# make into 2-dim table
	ndim=Dim[1]	#remember
	STRUCTURE(Dim/INT,2/)
	Dim[1]=1; Dim[2]=ndim; ndim=2
	P(Label)=yenter(P(Label),1,alcves(CHAR,1,NOARG))	#dummy first label
	NAME(FIRSTENT(VALUE(Label)))=istrng(" ",0)	#null category name
	}
if(MISSING(maxcol)) maxcol=ndim
if(MISSING(mincol)) mincol=min0(2,ndim)

STRUCTURE( scratch/INT,3*nvar+2*ndim/)
call prttbs(name, mode, value, nvar, Dim, ndim, VALUE(Label), mincol, maxcol, scratch )

END
