#ifdef DMD630
#include <dmd.h>
#include <5620.h>
#else
#include <jerq.h>
#ifdef mc68000
#undef menuhit
#endif
#endif
#include <font.h>
#include "scatmat.h"

extern Bitmap *Slayer;
short domenu(),dohighlight(),doidentify(),dorescale(),doinvert(),doselect(),dolocate();
Texture16 *mycursswitch();

short xtol,ytol;	/* brush size */
Rectangle sublayer;	/* current scatter plot */
Rectangle cursorbox;
short xdim, ydim, xoffset, yoffset;	/* determine current plot */
short (*action)(), shift;	/* current brush action */
short scale,sscale;	/* size of individual plot in rasters */
short n,m;	/* size of problem */
char **nams,**labs;
short inverted;
short *limits;

Bitmap *ball,*circle,*circleball;

scatmat(xyz,narg,marg,status,namsa,labsa,limitsa)
short *xyz,narg,marg,*status,*limitsa; char **namsa,**labsa;
{
	Point this;
	extern Texture16 nocursor;
	short i, b = 0, oldb = 0, d, *row;

	n = narg; m = marg; nams = namsa; labs = labsa; limits=limitsa;

	initialize(status);
	rectf(Slayer, Slayer->rect, F_CLR);	/* clear everything */

	mycursswitch(&nocursor);
	dogrid(BORDER);	/* draw grid, intital set of points */
	for(i=0; i<n; i++)
		dodraw(xyz+i*m,circle,F_XOR);
	dolims();
	myoutline();

	request(KBD|MOUSE);

	for(;;){	/* repeat forever ... */
		if(bttn1()) b=1;
		else if(bttn2()) b=2;
		else if(bttn3()) b=3;
		else b=0;

		cursorbox.corner = add(mouse.xy,Pt(xtol>>1,ytol>>1));
		cursorbox.origin = sub(cursorbox.corner,Pt(xtol,ytol));
		drawrect(cursorbox,F_XOR);

		for(i=0; i<n; i++){	/* loop through all points */
			if(ZAPPED(*(status+i))) continue;
			row = xyz + i*m;
			this.x = muldiv(*(row+xdim),sscale,MAXINT)+xoffset;
			this.y = yoffset - muldiv(*(row+ydim),sscale,MAXINT);
			/* see table below for the meaning of this */
			d = 1 - ptinrect(this, cursorbox);
			d = d*12 + ((*(status+i)>>shift)&03)*4 + b;
			switch(d){	/* do action */
			case 0: case 1: case 6: case 7: case 10:
			case 16: case 17: case 18: case 19:
				(*action)(row,*(status+i),i,labs?*(labs+i):NULL);
				}

			switch(d){	/* update status */
			case 0:
				*(status+i) &= ~(03<<shift);	/* clear */
				*(status+i) |= ON<<shift; 
				break;
			case 1: case 5:
				*(status+i) &= ~(03<<shift);	/* clear */
				*(status+i) |= STUCK<<shift; 
				break;
			case 6: case 7: case 10:
			case 16: case 17: case 18: case 19:
				*(status+i) &= ~(03<<shift);	/* clear (OFF) */
				break;
				}
			}
		nap(2);
		drawrect(cursorbox,F_XOR);
		if( b==3 && domenu(xyz,status)) break;	/* the only way out */
		if(oldb == 0 && b==1 && !ptinrect(mouse.xy,sublayer))
			doselect(xyz,status);
		oldb = b;
		} 
	mycursswitch((Texture16 *) 0);
}

/* Table of identification actions (cases numbered 0-23 down columns)

Distance to mouse    inside cursor box		outside cursor box
Previous status	OFF	ON	STUCK		OFF	ON	STUCK

Button:  0	+/ON					+/OFF	
	 1	+/STUCK	STUCK				+/OFF	
	 2		+/OFF	+/OFF			+/OFF	
	 3		+/OFF				+/OFF	

+ means execute the action code
/STATUS means set the status for this point

*/

static adjusttol()
{
	Rectangle r;
	r = getrect();
	if((r.corner.x-r.origin.x)>0 && (r.corner.y-r.origin.y)>0){
		xtol = r.corner.x - r.origin.x;
		ytol = r.corner.y - r.origin.y;
		}
}

static drawrect(r,mode)
Rectangle r; Code mode;
{
	segment(Slayer, r.corner, Pt(r.corner.x,r.origin.y), mode);
	segment(Slayer, Pt(r.corner.x,r.origin.y), r.origin, mode);
	segment(Slayer, r.origin, Pt(r.origin.x,r.corner.y), mode);
	segment(Slayer, Pt(r.origin.x,r.corner.y), r.corner, mode);
}

static char *items[] = {
	"Brush",
	"Highlight",
	"Delete",
	"Label",
	"Locate",
	"Shadow",
	"Rescale",
	"Pause",
	"Exit",
	NULL
	};

static Menu menu = { items };

static char *startitems[] = {
	"Resume",
	NULL
	};

static Menu startmenu = { startitems };

static Texture16 skull ={
	0x0000, 0x0000, 0x0000, 0xC003, 0xE7E7, 0x3FFC, 0x0FF0, 0x0DB0,
	0x07E0, 0x0660, 0x37EC, 0xE427, 0xC3C3, 0x0000, 0x0000, 0x0000
	};

static Texture16 nocursor = {
	 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	};

static Texture16 menucurs={
	0x0FF0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0, 0x0FF0, 0x0FF0, 
	0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0,
};

static short domenu(xyz,status)
short *xyz,*status;
{
	short dodelete(),dohighlight(),doidentify();
	short get_out = 0, i;
	items[1] = action==dohighlight?"* Highlight *":"Highlight";
	items[2] = action==dodelete?"* Delete *":"Delete";
	items[3] = action==doidentify?"* Label *":"Label";
	items[5] = inverted?"* Shadow *":"Shadow";
	switch(menuhit( &menu, 3)){
	case 0:	/* Brush */
		adjusttol();
		break;
	case 1:	/* Highlight */
		action = dohighlight;
		shift = HISHIFT;	/* shift right highlight status */
		break;
	case 2:	/* Delete */
		action = dodelete;
		shift = DELSHIFT;	/* shift right delete status */
		break;
	case 3:	/* Label */
		if(!labs) return(0);
		action = doidentify;
		shift = IDSHIFT;
		break;
	case 4:	/* Locate */
		mycursswitch(&menucurs);
		do {	/* locate until no selection is made by user */
			do; while(bttn123()==0);	/* wait button push */
			i = -1;
			if(bttn12()==0)
				i = dolocate(xyz,status);
			else
				do; while(bttn123()!=0);
		} while(i>=0);
		mycursswitch(&nocursor);
		break;
	case 5:	/* Shadow */
		doinvert(xyz,status);
		break;
	case 6:	/* Rescale */
		dorescale(xyz,status);
		break;
	case 7: /* Pause */
		drawrect(cursorbox,F_XOR);	/* leave old cursor */
		mycursswitch(&menucurs);
		for(;;){
			do wait(MOUSE); while(bttn123()==0);
			if(menuhit(&startmenu,3)>=0) break;
			};
		mycursswitch(&nocursor);
		drawrect(cursorbox,F_XOR);	/* erase old cursor */
		break;
	case 8:	/* Exit */
	getout:
		mycursswitch(&skull);
		get_out = 1;
		do; while(bttn123()==0);	/* wait for button push */
		while(bttn123())
			if(bttn12()){		/* only button 3 confirms */
				do; while(bttn123()!=0);
				mycursswitch(&nocursor); /* normal cursor */
				get_out = 0;	/* abort the exit */
				break;
				}
		}
	if(get_out) {
		cursswitch((Texture16 *)0);
		request(RCV);	/* free up the mouse */
		sendstr("Q");
		for(i=0; i<n; i++) sendchar(
			ZAPPED (status[i])?'3':
			DELETED(status[i])?'3':
			IDENTED(status[i])?'2':
			HILITED(status[i])?'1':
			'0'
			);
		sendchar('\n');
		}
	return(get_out);
}

/* display regular symbol and highlighted symbol at point */
static short dohighlight(row,status,i,lab)
short *row,status,i; char *lab;
{
	/* circleball is pre-XORed circle and ball */
	if(!DELETED(status)) dodraw(row,circleball,F_XOR);
}

/* display identification at point */
static short doidentify(row,status,i,lab)
short *row,status,i; char *lab;
{
	Bitmap *strng;
	if(lab!=NULL && (!DELETED(status))){
		strng = balloc(Rect(0,0,strwidth(&defont,lab)+2*RAD+2,defont.height));
		string(&defont,lab,strng,Pt(2*RAD+2,0),F_XOR);
		dodraw(row,strng,F_XOR);
		bfree(strng);
		}
}

/* delete symbol (highlighted or regular) at point */
static short dodelete(row,status,i,lab)
short *row,status,i; char *lab;
{
	if(HILITED(status)) dodraw(row,ball,F_XOR);
	else dodraw(row,circle,F_XOR);
}

static short dorescale(xyz,status) 
short *xyz,*status;
{
	short i;
	rectf(Slayer, Slayer->rect, F_CLR);	/* clear everything */
	dogrid(BORDER);
	myoutline();
	for(i=0; i<m; i++) scale_col(xyz+i,status,limits+2*i);
	for(i=0; i<n; i++){
		if(DELETED(status[i]))
			status[i] |= ZAP;	/* never again display this */
		else if(HILITED(status[i])) dodraw(xyz+i*m,ball,F_XOR);
		else dodraw(xyz+i*m,circle,F_XOR);
		}
	dolims();
}

static short doinvert(xyz,status) 
short *xyz,*status;
{
	short i;
	for(i=0; i<n; i++){
		if(ZAPPED(status[i])) /* nothing */;
		else if(HILITED(status[i])) dodraw(xyz+i*m,ball,F_XOR);
		else dodraw(xyz+i*m,circle,F_XOR);
		}
	inverted = !inverted;
	drawcurrent(xyz,status);
}

static short dolocate(xyz,status) 
short *xyz,*status;
{
	int i; Menu labmenu;
	labmenu.item = labs;
	i = menuhit( &labmenu, 3 );
	if((i>=0) && (i<n) && (!DELETED(status[i]))){
		dodraw(xyz+i*m,circleball,F_XOR);
		status[i] |= STUCK;
		}
}

static scale_col(vec,status,lims)
short *vec,*status,*lims;
{
	short i, j, mx, mn;
	mx = -1; mn = MAXINT;
	i = 0;
	for(j=0; j<n; j++){
		if(!DELETED(status[j])) {
			mx = mx>vec[i]?mx:vec[i];
			mn = mn<vec[i]?mn:vec[i];
			}
		i += m;
		}
	if(mx<=mn) return;
	j = lims[1]-lims[0];
	lims[1] = lims[0] + muldiv(mx,j,MAXINT);
	lims[0] = lims[0] + muldiv(mn,j,MAXINT);	/* update limits */
	mx = mx - mn;
	i = 0;
	for(j=0; j<n; j++){
		if(DELETED(status[j])) vec[i]=0;
		else vec[i] =  muldiv(vec[i]-mn,MAXINT,mx);
		i += m;
		}
}

static short doselect(xyz,status)
short *xyz,*status;
{
	Point p; short nx,ny;
	myoutline();
	while(bttn123()) ;	/* wait till button up */
	if(inverted)drawcurrent(xyz,status);
	p = sub(mouse.xy,Slayer->rect.origin);
	nx = p.x/scale; ny=p.y/scale;
	if(p.x>=0 && p.y>=0 && nx>=0 && nx<m && ny>=0 && ny<m & nx!=ny) {
		xdim = nx; ydim = ny;
		sublayer.origin.x = Slayer->rect.origin.x + xdim*scale + BORDER;
		sublayer.origin.y = Slayer->rect.origin.y + ydim*scale + BORDER;
		sublayer.corner = add(sublayer.origin, Pt(scale,scale));
		xoffset = sublayer.origin.x + RAD ;
		yoffset = sublayer.origin.y + sscale + RAD ;
		}
	myoutline();
	if(inverted)drawcurrent(xyz,status);
}

/* display all points for a single observation */
static dodraw(xy,symbol,mode)
short *xy; Bitmap *symbol; Code mode;
{
	short i,j,xcoord,ycoord; Point p;
	for(j=0; j<m; j++){
		xcoord = muldiv(*(xy+j),sscale,MAXINT);
		for(i=j+1; i<m; i++){
			ycoord = muldiv(*(xy+i),sscale,MAXINT);
			p.x = xcoord + j*scale + BORDER;
			p.y = i*scale + sscale + BORDER - ycoord;
			bitblt(symbol, symbol->rect, Slayer, 
				add(p,Slayer->rect.origin), mode);
			p.x = ycoord + i*scale + BORDER;
			p.y = j*scale + sscale + BORDER - xcoord;
			bitblt(symbol, symbol->rect, Slayer, 
				add(p,Slayer->rect.origin), mode);
			}
		}
}

static drawcurrent(xyz,status)
short *xyz,*status;
{
	Point p; short i,*row;
	for(i=0; i<n; i++){	/* loop through all points */
		if(ZAPPED(*(status+i))) continue;
		row = xyz + i*m;
		p.x = muldiv(*(row+xdim),sscale,MAXINT)+xoffset-RAD;
		p.y = yoffset - muldiv(*(row+ydim),sscale,MAXINT)-RAD;
		if(HILITED(status[i]))
			bitblt(ball, ball->rect, Slayer, p, F_XOR);
		else
			bitblt(circle, circle->rect, Slayer, p, F_XOR);
	}
}

static dogrid(thick)
short thick;
{
	short i,j; Point o;
	o = Slayer ->rect.origin;
	for(i=0; i<=m; i++)
		for(j=0; j<thick; j++)
			segment(Slayer, add(o,Pt(i*scale+j,0)),
				add(o,Pt(i*scale+j,m*scale)),F_XOR);
	for(i=0; i<=m; i++)
		for(j=0; j<thick; j++)
			segment(Slayer, add(o,Pt(0,i*scale+j)),
				add(o,Pt(m*scale,i*scale+j)),F_XOR);
	j = BORDER/2;
	if(j!=0){
		for(i=0; i<=m; i++)
			segment(Slayer, add(o,Pt(i*scale+j,0)),
				add(o,Pt(i*scale+j,m*scale)),F_XOR);
		for(i=0; i<=m; i++)
			segment(Slayer, add(o,Pt(0,i*scale+j)),
				add(o,Pt(m*scale,i*scale+j)),F_XOR);
		}
	for(i=0; i<m; i++)
		string(&defont, nams[i], Slayer, add(o,
			Pt(i*scale+(scale-strwidth(&defont,nams[i]))/2, i*scale+scale/2-defont.height/2)),
			F_XOR);
}

static dolims()
{
	short i,top; static char buf[10]; Point o; char *p,*getlab();
	o = Slayer->rect.origin;
	sendstr("L");
	for(i=0; i<2*m; i++) {	/* transmit limits */
		sprintf(buf,"%d",limits[i]);
		sendstr(buf);
		}
	for(i=0; i<m; i++) {
		p = getlab();
		string(&defont, p, Slayer, add(o,
			Pt(i*scale+RAD, i*scale+scale-defont.height)),
			F_XOR);
		free(p);
		p = getlab();
		string(&defont, p, Slayer, add(o,
			Pt(i*scale+scale-strwidth(&defont,p),i*scale+RAD)),
			F_XOR);
		free(p);
		}
	}

static sendstr(s)
char *s;
{
	while(*s) sendchar(*s++);
	sendchar('\n');
}

static myoutline()
{
	drawrect(rsubp(sublayer,Pt(BORDER/2+1,BORDER/2+1)),F_XOR);
}

static initialize(status)
short *status;
{

	short i,j,scalex,scaley;
	short dohighlight();

	scalex = Slayer->rect.corner.x - Slayer->rect.origin.x;
	scaley = Slayer->rect.corner.y - Slayer->rect.origin.y;
	scale = ((scalex>scaley?scaley:scalex)-BORDER) / m;	/* rasters per scatter */
	sscale = scale - 2*RAD - BORDER;	/* keeps symbol inside plot */
	xtol = ytol = sscale/4;

	xdim = 0; ydim = 1;
	sublayer.origin.x = Slayer->rect.origin.x + xdim*scale + BORDER;
	sublayer.origin.y = Slayer->rect.origin.y + ydim*scale + BORDER;
	sublayer.corner = add(sublayer.origin, Pt(scale,scale));
	xoffset = sublayer.origin.x + RAD ;
	yoffset = sublayer.origin.y + sscale + RAD ;
	action = dohighlight;
	shift = HISHIFT;
	inverted = 0;

	/* initialize ball and circle symbols */
	ball = balloc(Rect(0,0,RAD*2+1,RAD*2+1));
	circle = balloc(Rect(0,0,RAD*2+1,RAD*2+1));
	circleball = balloc(Rect(0,0,RAD*2+1,RAD*2+1));
	rectf(ball, ball->rect, F_CLR);
	rectf(circle, circle->rect, F_CLR);
	disc(ball,add(ball->rect.origin, Pt(RAD,RAD)), RAD, F_XOR);
	disc(circle,add(circle->rect.origin, Pt(RAD,RAD)), RAD, F_XOR);
	disc(circle,add(circle->rect.origin, Pt(RAD,RAD)), RAD-1, F_XOR);
	bitblt(circle,circle->rect,circleball,Pt(0,0),F_STORE);
	bitblt(ball,ball->rect,circleball,Pt(0,0),F_XOR);

	j=0;
	for(i=0; i<m; i++) { limits[j++] = 0; limits[j++] = MAXINT; }
}


/* kludge to get cursor to switch in graph layer */
Texture16 *mycursswitch(t)
Texture16 *t;
{
	Texture16 *out;
#ifdef DMD630
	out = Cursswitch(t);
#else
	out = cursswitch(t);
#endif
	return out;
}
