/* Filling interior of arbitrary polygons on the Blit */

#ifdef DMD630
#include <dmd.h>
#include <5620.h>
#define texture16 texture
#else
#include <blit.h>
#endif
#include <font.h>

struct seg { short x, y, X, Y; char stat;} ;
typedef struct seg segS;
typedef struct seg * segP;

extern Bitmap *Slayer;

#define COMP(A)  if(p1->A>p2->A) return(-1); else if(p1->A<p2->A) return(1);

place(p1,p2) segP p1, p2;
{
	COMP(y) else { 
		COMP(x) else { 
			COMP(X) else { 
				COMP(Y) else return(0);
			}
		}
	}
}


mkseg(sp,x,y,X,Y) segP sp; short x,y,X,Y;
{
	if(Y>y) { sp->x=X; sp->y=Y; sp->X=x; sp->Y=y; }
	else if(Y==y && x<X) { sp->x=X; sp->y=Y; sp->X=x; sp->Y=y; }
	else { sp->x=x; sp->y=y; sp->X=X; sp->Y=Y; }
}

polygon(x,y,n,tex) short x[], y[], n; Texture16 *tex;
{
	segP sinp, sp; short i;
	sinp = (segP) alloc(n*sizeof(struct seg));
	sp = sinp;
	for(i=1; i<n; i++)
		mkseg(sp++, x[i-1], y[i-1], x[i], y[i]);
	mkseg(++sp, x[n], y[n], x[0], y[0]);
	realfill(sinp,n,tex);
	free(sinp);
}

/* Fill a contour defined by a set of line segments */

realfill(sinp,so,tex) segP sinp; short so; Texture16 *tex;
{
	short i, n, yb, ymin;
	segP  sp, s1, s2, sfin, st, sbf, snx;
	ymin = 2000;
	for(i=0,sp=sinp;i<so;i++,sp++) {
		sp->stat = 1; 
		if(sp->y<ymin) ymin = sp->y;
		if(sp->Y<ymin) ymin = sp->Y;
	}
	sfin = sp; 	/*sp was not incremented last time*/
	/* edit horizontal lines */
	for(i=0,sp=sinp;i<so;i++,sp++){
		if(!(sp->stat)) continue;
		if(sp->y != sp->Y) continue;
		if(sp==sinp) sbf = sp+so-1; 
		else sbf = sp-1;
		if(sp<sfin) snx = sp+1;
		else snx = sp;
		if(sbf->y==sp->y){	/* point before is below*/
			if(snx->y==sp->y){	/* both below */
				sp->stat = 0;
			}
			continue;
		}
		else if(sbf->Y==sp->y){	/*previous point above*/
			if(snx->Y==sp->y){	/* both above */
				sp->stat = 0;
			}
			continue;
		}
	}
	/* finished with horizontal editing */

	qsort(sinp,so,sizeof(struct seg),place);

	sp = sinp; 
	i = 0;
	n = so;
	s1 = sp; 
	yb = s1->y;
	for(;yb<=sp->y;sp++,i++);
	s2 = sp - 1;
	for(;yb>=ymin;yb--){
		Sdraw(yb,s1,s2,tex);
		for(st=s1;st<=s2;st++){
			if(!(st->stat)) continue;
			if(yb<=st->Y) st->stat=0;
		}
		if(sp >= sfin) continue; /*nomore*/
		if(i>=n) continue;
		for(;yb<=(sp->y+1)&&i<n;sp++,i++){ /*we have gone below next element */
			for(st=s1;st<=s2;st++){
				if(sp->y==st->Y){
					if(sp->x==st->X) st->stat=0;
					else if(sp->Y==sp->y&&sp->X==st->X) st->stat=0;
				}
			}
		}
		/*cleanup*/
		s2 = sp - 1;
		while(s1<sfin && !(s1->stat)) s1++;
	}
}

#define NCUTS 32
#define NCUTS_1 31
Sdraw(y,pr1,pr2,tex) short y;  segP pr1, pr2; Texture16 *tex;
{
	register segP pr;
	register i, j, k, n;
	short x[NCUTS];
	for(pr=pr1,n=0;pr<=pr2;pr++){
		if(!(pr->stat)) continue;
		if(pr->y==pr->Y) continue; /* ignore horizontals */
		x[n++] = xcut(y,pr->x,pr->y,pr->X,pr->Y);
		if(n>NCUTS_1) break; /* jtag(1,"Too many intersections"); */
	}
	if(n<=1) return(0);
	k=1;
	while(k){
		k = 0;
		for(i=1;i<n;i++){
			if(x[i-1]>x[i]) {
				j=x[i-1]; 
				x[i-1]=x[i]; 
				x[i]=j; 
				k=1;
			}
		}
	}
	for(i=1;i<n;i +=2) {
		texture16(Slayer,Rect(x[i-1]+1,y,x[i]+1,y+1),tex,F_STORE);
	}
	return(1);
}

xcut(y,x1,y1,x2,y2){
	long dx, dy, xy;
	short x;
	if(y1==y2) {
		x = x1>x2? x1: x2; 
		return(x);
	}
	dy = y1-y2; 
	dx = x1-x2; 
	xy = (long)y1*x2-x1*(long)y2;
	x = (y*dx+xy)/dy;	/*dy non zero because of prev. check*/
	return(x);
}
