FUNCTION usa(
	states	/LGL,1,TRUE/
	coast	/LGL,1,TRUE/
	add	/LGL,1,FALSE/
	xlim	/REAL,OPTIONAL/
	ylim	/REAL,OPTIONAL/
	fifty	/LGL,1,FALSE/
	PAR
	)
STATIC( real x(44),y(44) )
if(add) QUERY( usr(xmin,xmax,ymin,ymax) )
else{ xmin=-130.; xmax=-65.; ymin=24.; ymax=50. }
if(!MISSING(xlim)){
	CHECK(LENGTH(xlim)==2,FATAL(Bad Xlim))
	xmin=-amax1(abs(xlim[1]),abs(xlim[2]))
	xmax=-amin1(abs(xlim[1]),abs(xlim[2]))
	}
if(!MISSING(ylim)){
	CHECK(LENGTH(ylim)==2,FATAL(Bad Ylim))
	ymin=amin1(abs(ylim[1]),abs(ylim[2]))
	ymax=amax1(abs(ylim[1]),abs(ylim[2]))
	}
if(!add){	#set up plot with correct aspect ratio
	call beginz
	QUERY( pin(px,py) )
	dx=.8*(xmax-xmin); dy=ymax-ymin	# .8 degree of latitude = degree of longitude
	coord=amin1(px/dx,py/dy)	# inches per degree longitude
	xextra=(px/coord-dx)*.5/.8; yextra=(py/coord-dy)*.5
	SPECIFY( usr(xmin-xextra,xmax+xextra,ymin-yextra,ymax+yextra) )
	QUERY( usr(xmin,xmax,ymin,ymax) )
	}

if(coast)istart=0; else istart=24
if(states & fifty) iend=75; else if(states) iend=73; else iend=24
QUERY( err(ierr) );SPECIFY( err(-1) )	#turn off GR-Z errors (for clipping)
for(iseg=istart;iseg<iend;){
	call usabdy(x,y,n,iseg)
	if(n<=0)break
	if(!MISSING(xlim)){	#check for all x out on same side of limit
		if (x(1)<xmin) {
			for(i=1;i<=n & x(i)<xmin ;i=i+1);
			if(i>n)next
		} else if (x(1)>xmax) {
			for(i=1;i<=n & x(i)>xmax ;i=i+1);
			if(i>n)next
		}
	}
	if(!MISSING(ylim)){	#check for all y out on same side of limit
 		if (y(1)<ymin) {
 			for(i=1;i<=n & y(i)<ymin ;i=i+1);
 			if(i>n)next
 		} else if (y(1)>ymax) {
 			for(i=1;i<=n & y(i)>ymax ;i=i+1);
 			if(i>n)next
		}
	}
	call linesz(x,y,n)
}
SPECIFY( err(ierr) )
END
